package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;

import java.util.List;

import io.reactivex.Flowable;

@Dao
public abstract class EkoFollowCountDao extends EkoObjectDao<EkoFollowCountEntity> {

    @Query("UPDATE user_follow_count set followerCount = :followerCount where userId = :userId")
    public abstract void updateFollowerCount(String userId, int followerCount);

    @Query("UPDATE user_follow_count set followingCount = :followingCount where userId = :userId")
    public abstract void updateFollowingCount(String userId, int followingCount);

    @Query("UPDATE user_follow_count set pendingCount = :pendingCount where userId = :userId")
    public abstract void updatePendingCount(String userId, int pendingCount);

    @Query("DELETE from user_follow_count")
    public abstract void deleteAll();

    @Query("SELECT * from user_follow_count where userId = :userId LIMIT 1")
    abstract EkoFollowCountEntity getByIdNowImpl(String userId);

    @Nullable
    public EkoFollowCountEntity getByIdNow(@NonNull String userId) {
        return getByIdNowImpl(userId);
    }

    @Query("SELECT * from user_follow_count" +
            " where user_follow_count.userId = :userId" +
            " LIMIT 1")
    abstract io.reactivex.rxjava3.core.Flowable<EkoFollowCountEntity> getByIdImpl(String userId);

    public io.reactivex.rxjava3.core.Flowable<EkoFollowCountEntity> getById(String userId) {
        return getByIdImpl(userId);
    }

    @Query("SELECT * from user_follow_count" +
            " where user_follow_count.userId = :userId")
    abstract Flowable<List<EkoFollowCountEntity>> getAllByIdImpl(String userId);

    public Flowable<List<EkoFollowCountEntity>> getAllById(String userId) {
        return getAllByIdImpl(userId);
    }
}