package com.amity.socialcloud.sdk.entity.core.notificationtray

import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverters
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayActor
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.joda.time.DateTime

@Entity(tableName = "notificationTrayItem")
@TypeConverters(NotificationTrayActorIdMapTypeConverter::class)
open class NotificationTrayItemEntity(): EkoObject() {
    @PrimaryKey
    var notificationId: String = ""
    var targetId: String = ""
    var targetType: String = "unknown"
    var actionType: String? = null
    var actionReferenceId: String? = null
    var actors: List<AmityNotificationTrayActor> = emptyList()
    var actorsCount: Int? = null
    var data: JsonObject? = null
    var daySegment: DateTime? = null
    var lastOccurredAt: DateTime? = null
    var lastSeenAt: DateTime? = null
    var parentId: String? = null
    var referenceId: String? = null
    var referenceType: String? = null
    var templatedText: String? = null
    var text: String? = null
    var trayItemCategory: String? = null

    override fun getId(): String {
        return notificationId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is NotificationTrayItemEntity
                && Objects.equal(targetId, other.targetId)
                && Objects.equal(targetType, other.targetType)
                && Objects.equal(actionType, other.actionType)
                && Objects.equal(actionReferenceId, other.actionReferenceId)
                && Objects.equal(actors, other.actors)
                && Objects.equal(actorsCount, other.actorsCount)
                && Objects.equal(data, other.data)
                && Objects.equal(daySegment, other.daySegment)
                && Objects.equal(notificationId, other.notificationId)
                && Objects.equal(lastOccurredAt, other.lastOccurredAt)
                && Objects.equal(lastSeenAt, other.lastSeenAt)
                && Objects.equal(parentId, other.parentId)
                && Objects.equal(referenceId, other.referenceId)
                && Objects.equal(referenceType, other.referenceType)
                && Objects.equal(templatedText, other.templatedText)
                && Objects.equal(text, other.text)
                && Objects.equal(trayItemCategory, other.trayItemCategory)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            targetId,
            targetType,
            actionType,
            actionReferenceId,
            actors,
            actorsCount,
            data,
            notificationId,
            daySegment,
            lastOccurredAt,
            lastSeenAt,
            parentId,
            referenceId,
            referenceType,
            templatedText,
            text,
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("targetId", targetId)
            add("targetType", targetType)
            add("lastOccurredAt", lastOccurredAt)
            add("lastSeenAt", lastSeenAt)
            add("action", actionType)
            add("actionReferenceId", actionReferenceId)
            add("actors", actors)
            add("actorsCount", actorsCount)
            add("data", data)
            add("id", notificationId)
            add("parentId", parentId)
            add("referenceId", referenceId)
            add("referenceType", referenceType)
            add("templatedText", templatedText)
            add("text", text)
            add("trayItemCategory", trayItemCategory)
            add("lastSeenAt", lastSeenAt)
            add("lastOccurredAt", lastOccurredAt)
            add("daySegment", daySegment)
        }
        return super.internalToString(toStringHelper)
    }

}
