package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.UserMarkerEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class UserMarkerDao : EkoObjectDao<UserMarkerEntity>() {
	@Query("SELECT * from user_marker LIMIT 1")
	abstract fun get(): Flowable<UserMarkerEntity>
	
	@Query("DELETE from user_marker")
	abstract override fun deleteAll()
	
	@Query("DELETE from user_marker where userId = :userId")
	abstract fun deleteById(userId: String)
}