package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.model.core.unread.Unread
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class ChannelUnreadInfoDao : EkoObjectDao<ChannelUnreadInfoEntity>() {
	@Query("SELECT * from channel_unread_info where channelId = :channelId LIMIT 1")
	abstract fun getById(channelId: String): Flowable<ChannelUnreadInfoEntity>
	
	@Query("SELECT * from channel_unread_info where channelId = :channelId LIMIT 1")
	abstract fun getByChannelIdNow(channelId: String): ChannelUnreadInfoEntity?
	
	@Query("DELETE from channel_unread_info")
	abstract override fun deleteAll()
	
	@Query("DELETE from channel_unread_info where channelId = :channelId")
	abstract fun deleteById(channelId: String)
	
	@Query("SELECT COALESCE(SUM(channel_unread_info.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread_info.isMentioned), 0) as isMentioned from channel_unread_info where channel_unread_info.channelId in (SELECT channelId from channel)")
	abstract fun getTotalChannelsUnreadInfo(): Flowable<Unread>
}