package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.ekoapp.ekosdk.internal.data.converter.EkoGson.get

class EkoPermissionsTypeConverter {
	@TypeConverter
	fun stringToEkoPermissions(json: String?): AmityPermissions? {
		return json?.let { get().fromJson(it, AmityPermissions::class.java) }
	}
	
	@TypeConverter
	fun ekoPermissionsToString(permissions: AmityPermissions?): String? {
		return permissions?.let(get()::toJson)
	}
}