/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.storytarget;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.storytarget.AmityGlobalStoryTargetsQueryOption;
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\bJ\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000f0\u00142\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0!0\u000fJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001c\u001a\u00020\bJ\u0014\u0010#\u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fJ \u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ \u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\nJ(\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\n\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/social/data/storytarget/StoryTargetLocalDataStore;", "", "()V", "createStoryTarget", "Lio/reactivex/rxjava3/core/Completable;", "targetType", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "targetId", "", "lastStoryExpiresAt", "Lorg/joda/time/DateTime;", "localLastStoryExpiresAt", "lastStorySeenExpiresAt", "localLastStorySeenExpiresAt", "findCacheKeys", "", "option", "Lcom/amity/socialcloud/sdk/api/social/storytarget/AmityGlobalStoryTargetsQueryOption;", "expiresAfter", "getLatestStoryTargets", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/entity/social/story/StoryTargetEntity;", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "", "getStoryTarget", "getStoryTargetById", "uniqueId", "getStoryTargetPagingSource", "Landroidx/paging/PagingSource;", "getStoryTargets", "targets", "Lkotlin/Pair;", "observeStoryTarget", "saveStoryTarget", "storyTargets", "updateStoryTargetLastStoryExpiresAt", "updateStoryTargetLocalLastStoryExpiresAt", "updateStoryTargetLocalLastStorySeenExpiresAt", "updateStoryTargetLocalSortingDate", "hasUnseen", "", "localSortingDate", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nStoryTargetLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoryTargetLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/storytarget/StoryTargetLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1855#2,2:173\n*S KotlinDebug\n*F\n+ 1 StoryTargetLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/storytarget/StoryTargetLocalDataStore\n*L\n19#1:173,2\n*E\n"})
public final class StoryTargetLocalDataStore {
    @NotNull
    public final Completable saveStoryTarget(@NotNull List<StoryTargetEntity> storyTargets) {
        Intrinsics.checkNotNullParameter(storyTargets, (String)"storyTargets");
        Completable completable = Completable.fromAction(() -> StoryTargetLocalDataStore.saveStoryTarget$lambda$1(storyTargets)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final List<String> findCacheKeys(@NotNull AmityGlobalStoryTargetsQueryOption option, @Nullable DateTime expiresAfter) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        return UserDatabase.get().storyTargetDao().findCacheKeys(option, expiresAfter);
    }

    @NotNull
    public final Completable createStoryTarget(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @Nullable DateTime lastStoryExpiresAt, @Nullable DateTime localLastStoryExpiresAt, @Nullable DateTime lastStorySeenExpiresAt, @Nullable DateTime localLastStorySeenExpiresAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Completable completable = Completable.fromAction(() -> StoryTargetLocalDataStore.createStoryTarget$lambda$3(targetType, targetId, lastStoryExpiresAt, localLastStoryExpiresAt, lastStorySeenExpiresAt, localLastStorySeenExpiresAt));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026f(storyTarget))\n        }");
        return completable;
    }

    @Nullable
    public final StoryTargetEntity getStoryTarget(@NotNull AmityStory.TargetType targetType, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return UserDatabase.get().storyTargetDao().getStoryTarget(targetType.getApiKey(), targetId);
    }

    @Nullable
    public final StoryTargetEntity getStoryTargetById(@NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return UserDatabase.get().storyTargetDao().getByIdNowImpl(uniqueId);
    }

    @NotNull
    public final Flowable<StoryTargetEntity> observeStoryTarget(@NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return UserDatabase.get().storyTargetDao().observeStory(uniqueId);
    }

    @NotNull
    public final Completable updateStoryTargetLocalLastStoryExpiresAt(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @Nullable DateTime localLastStoryExpiresAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return UserDatabase.get().storyTargetDao().updateStoryTargetLocalLastStoryExpiresAt(targetType.getApiKey(), targetId, localLastStoryExpiresAt);
    }

    @NotNull
    public final Completable updateStoryTargetLastStoryExpiresAt(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @Nullable DateTime lastStoryExpiresAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return UserDatabase.get().storyTargetDao().updateStoryTargetLastStoryExpiresAt(targetType.getApiKey(), targetId, lastStoryExpiresAt);
    }

    @NotNull
    public final Completable updateStoryTargetLocalLastStorySeenExpiresAt(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, @Nullable DateTime localLastStorySeenExpiresAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return UserDatabase.get().storyTargetDao().updateStoryTargetLocalLastStorySeenExpiresAt(targetType.getApiKey(), targetId, localLastStorySeenExpiresAt);
    }

    @NotNull
    public final Completable updateStoryTargetLocalSortingDate(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, boolean hasUnseen, @Nullable DateTime localSortingDate) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return UserDatabase.get().storyTargetDao().updateStoryTargetHasUnseen(targetType.getApiKey(), targetId, hasUnseen, localSortingDate);
    }

    @NotNull
    public final Flowable<List<StoryTargetEntity>> getStoryTargets(@NotNull List<? extends Pair<? extends AmityStory.TargetType, String>> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        return UserDatabase.get().storyTargetSinglePageDao().getStoryTargetByTargets(targets);
    }

    @NotNull
    public final PagingSource<Integer, StoryTargetEntity> getStoryTargetPagingSource(@NotNull AmityGlobalStoryTargetsQueryOption option) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        return UserDatabase.get().storyTargetPagingDao().getStoryTargetPagingSource(option);
    }

    @NotNull
    public final Flowable<StoryTargetEntity> getLatestStoryTargets(@NotNull AmityGlobalStoryTargetsQueryOption option, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        return UserDatabase.get().storyTargetDao().getLatestStoryTargets(option, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, DateTime.now());
    }

    private static final void saveStoryTarget$lambda$1(List $storyTargets) {
        Intrinsics.checkNotNullParameter((Object)$storyTargets, (String)"$storyTargets");
        Iterable $this$forEach$iv = $storyTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isCacheMoreRecent;
            boolean bl;
            StoryTargetEntity it = (StoryTargetEntity)element$iv;
            boolean bl2 = false;
            StoryTargetEntity cache = UserDatabase.get().storyTargetDao().getStoryTarget(it.getTargetType(), it.getTargetId());
            if (cache == null) continue;
            it.setLocalLastStoryExpiresAt(cache.getLocalLastStoryExpiresAt());
            it.setLocalLastStorySeenExpiresAt(cache.getLocalLastStorySeenExpiresAt());
            if (cache.getLocalSortingDate() == null) {
                bl = false;
            } else if (it.getLocalSortingDate() == null) {
                bl = true;
            } else {
                DateTime dateTime = it.getLocalSortingDate();
                Intrinsics.checkNotNull((Object)dateTime);
                bl = dateTime.isBefore((ReadableInstant)cache.getLocalSortingDate());
            }
            if (!(isCacheMoreRecent = bl)) continue;
            it.setLocalSortingDate(cache.getLocalSortingDate());
            it.setHasUnseen(cache.getHasUnseen());
        }
        UserDatabase.get().storyTargetDao().save($storyTargets);
    }

    private static final void createStoryTarget$lambda$3(AmityStory.TargetType $targetType, String $targetId, DateTime $lastStoryExpiresAt, DateTime $localLastStoryExpiresAt, DateTime $lastStorySeenExpiresAt, DateTime $localLastStorySeenExpiresAt) {
        StoryTargetEntity storyTargetEntity;
        Intrinsics.checkNotNullParameter((Object)((Object)$targetType), (String)"$targetType");
        Intrinsics.checkNotNullParameter((Object)$targetId, (String)"$targetId");
        StoryTargetEntity $this$createStoryTarget_u24lambda_u243_u24lambda_u242 = storyTargetEntity = new StoryTargetEntity();
        boolean bl = false;
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setUniqueId(AmityStoryTarget.Companion.generateUniqueId$amity_sdk_release($targetType.getApiKey(), $targetId));
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setTargetType($targetType.getApiKey());
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setTargetId($targetId);
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setLastStoryExpiresAt($lastStoryExpiresAt);
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setLocalLastStoryExpiresAt($localLastStoryExpiresAt);
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setLastStorySeenExpiresAt($lastStorySeenExpiresAt);
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setLocalLastStorySeenExpiresAt($localLastStorySeenExpiresAt);
        $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setLocalSortingDate($localLastStoryExpiresAt);
        DateTime dateTime = $localLastStoryExpiresAt;
        if (dateTime != null ? dateTime.isAfter((ReadableInstant)DateTime.now()) : false) {
            $this$createStoryTarget_u24lambda_u243_u24lambda_u242.setHasUnseen(true);
        }
        StoryTargetEntity storyTarget = storyTargetEntity;
        UserDatabase.get().storyTargetDao().save(CollectionsKt.listOf((Object)storyTarget));
    }
}

