package com.amity.socialcloud.sdk.entity.core.notificationtray

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayActorIdMap
import com.google.gson.GsonBuilder
import com.google.gson.InstanceCreator
import com.google.gson.reflect.TypeToken
import org.joda.time.Chronology
import org.joda.time.chrono.ISOChronology
import java.lang.reflect.Type

class NotificationTrayActorIdMapTypeConverter {
    @TypeConverter
    fun fromString(json: String?): AmityNotificationTrayActorIdMap {
        if (json.isNullOrBlank()) return AmityNotificationTrayActorIdMap()
        val trimmedJson = json.trim()
        if (!trimmedJson.startsWith("{")) return AmityNotificationTrayActorIdMap()

        return try {
            val gson = GsonBuilder()
                .registerTypeAdapter(Chronology::class.java, ChronologyInstanceCreator())
                .create()
            val type = object : TypeToken<AmityNotificationTrayActorIdMap>() {}.type
            gson.fromJson<AmityNotificationTrayActorIdMap>(trimmedJson, type)
                ?: AmityNotificationTrayActorIdMap()
        } catch (e: Exception) {
            e.printStackTrace()
            AmityNotificationTrayActorIdMap()
        }
    }

    @TypeConverter
    fun toString(map: AmityNotificationTrayActorIdMap?): String? {
        if (map == null) return null
        return GsonBuilder()
            .registerTypeAdapter(Chronology::class.java, ChronologyInstanceCreator())
            .create()
            .toJson(map)
    }

    class ChronologyInstanceCreator : InstanceCreator<Chronology> {
        override fun createInstance(type: Type?): Chronology {
            return ISOChronology.getInstance()
        }
    }
}

