/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.amity.socialcloud.sdk.model.core.user.AmityUserType;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import java.util.UUID;
import org.joda.time.DateTime;

@Entity(tableName="account")
public class EkoAccount {
    @PrimaryKey
    @NonNull
    private String userId;
    private String deviceId;
    private String refreshToken;
    private String accessToken;
    private DateTime issuedAt;
    private DateTime expiresAt;
    private DateTime aboutToExpireAt;
    private String userType;
    private String loginMethod;

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken2) {
        this.refreshToken = refreshToken2;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DateTime getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(DateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public DateTime getAboutToExpireAt() {
        return this.aboutToExpireAt;
    }

    public void setAboutToExpireAt(DateTime aboutToExpireAt) {
        this.aboutToExpireAt = aboutToExpireAt;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getLoginMethod() {
        return this.loginMethod;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userId", (Object)this.userId).add("deviceId", (Object)this.deviceId).add("refreshToken", (Object)this.refreshToken).add("issuedAt", this.issuedAt.getMillis()).add("expiresAt", this.expiresAt.getMillis()).add("aboutToExpireAt", this.aboutToExpireAt.getMillis()).add("userType", (Object)this.userType).add("loginMethod", (Object)this.loginMethod).toString();
    }

    public static EkoAccount create(@NonNull String userId) {
        return EkoAccount.create(userId, null);
    }

    public static EkoAccount create(@NonNull String userId, String accessToken) {
        EkoAccount account = new EkoAccount();
        account.setUserId(userId);
        if (accessToken != null) {
            account.setAccessToken(accessToken);
        }
        account.setUserType(AmityUserType.SIGNED_IN.getValue());
        account.setDeviceId(UUID.randomUUID().toString());
        return account;
    }

    public static EkoAccount create() {
        EkoAccount account = new EkoAccount();
        String deviceId = UUID.randomUUID().toString();
        account.setUserId(deviceId);
        account.setUserType(AmityUserType.VISITOR.getValue());
        account.setDeviceId(deviceId);
        return account;
    }
}

