/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoAccountDao_Impl
extends EkoAccountDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoAccount> __insertAdapterOfEkoAccount;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoAccount> __deleteAdapterOfEkoAccount;
    private final EntityDeleteOrUpdateAdapter<EkoAccount> __updateAdapterOfEkoAccount;

    public EkoAccountDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoAccount = new EntityInsertAdapter<EkoAccount>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `account` (`userId`,`deviceId`,`refreshToken`,`accessToken`,`issuedAt`,`expiresAt`,`aboutToExpireAt`,`userType`,`loginMethod`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoAccount entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getDeviceId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getDeviceId());
                }
                if (entity.getRefreshToken() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getRefreshToken());
                }
                if (entity.getAccessToken() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getAccessToken());
                }
                String _tmp = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getIssuedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getAboutToExpireAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getUserType() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserType());
                }
                if (entity.getLoginMethod() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getLoginMethod());
                }
            }
        };
        this.__deleteAdapterOfEkoAccount = new EntityDeleteOrUpdateAdapter<EkoAccount>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `account` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoAccount entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoAccount = new EntityDeleteOrUpdateAdapter<EkoAccount>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR REPLACE `account` SET `userId` = ?,`deviceId` = ?,`refreshToken` = ?,`accessToken` = ?,`issuedAt` = ?,`expiresAt` = ?,`aboutToExpireAt` = ?,`userType` = ?,`loginMethod` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoAccount entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getDeviceId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getDeviceId());
                }
                if (entity.getRefreshToken() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getRefreshToken());
                }
                if (entity.getAccessToken() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getAccessToken());
                }
                String _tmp = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getIssuedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoAccountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getAboutToExpireAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getUserType() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserType());
                }
                if (entity.getLoginMethod() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getLoginMethod());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getUserId());
                }
            }
        };
    }

    @Override
    void insert(EkoAccount ekoAccount) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoAccount.insert(_connection, (Object)ekoAccount);
            return null;
        });
    }

    @Override
    public void delete(EkoAccount account) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoAccount.handle(_connection, (Object)account);
            return null;
        });
    }

    @Override
    public void update(EkoAccount ekoAccount) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoAccount.handle(_connection, (Object)ekoAccount);
            return null;
        });
    }

    @Override
    public EkoAccount activateAccount(String userId, String accessToken) {
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> EkoAccountDao_Impl.super.activateAccount(userId, accessToken));
    }

    @Override
    public EkoAccount activateVisitor() {
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> EkoAccountDao_Impl.super.activateVisitor());
    }

    @Override
    public EkoAccount deactivateAccount(String userId) {
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> EkoAccountDao_Impl.super.deactivateAccount(userId));
    }

    @Override
    public void logoutAccount(String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoAccountDao_Impl.super.logoutAccount(userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<List<EkoAccount>> getAll() {
        String _sql = "SELECT * from account";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from account");){
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfRefreshToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"refreshToken");
                int _columnIndexOfAccessToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessToken");
                int _columnIndexOfIssuedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"issuedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfAboutToExpireAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"aboutToExpireAt");
                int _columnIndexOfUserType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userType");
                int _columnIndexOfLoginMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"loginMethod");
                ArrayList<EkoAccount> _result = new ArrayList<EkoAccount>();
                while (_stmt.step()) {
                    EkoAccount _item = new EkoAccount();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    _item.setDeviceId(_tmpDeviceId);
                    String _tmpRefreshToken = _stmt.isNull(_columnIndexOfRefreshToken) ? null : _stmt.getText(_columnIndexOfRefreshToken);
                    _item.setRefreshToken(_tmpRefreshToken);
                    String _tmpAccessToken = _stmt.isNull(_columnIndexOfAccessToken) ? null : _stmt.getText(_columnIndexOfAccessToken);
                    _item.setAccessToken(_tmpAccessToken);
                    String _tmp = _stmt.isNull(_columnIndexOfIssuedAt) ? null : _stmt.getText(_columnIndexOfIssuedAt);
                    DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setIssuedAt(_tmpIssuedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setExpiresAt(_tmpExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAboutToExpireAt) ? null : _stmt.getText(_columnIndexOfAboutToExpireAt);
                    DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setAboutToExpireAt(_tmpAboutToExpireAt);
                    String _tmpUserType = _stmt.isNull(_columnIndexOfUserType) ? null : _stmt.getText(_columnIndexOfUserType);
                    _item.setUserType(_tmpUserType);
                    String _tmpLoginMethod = _stmt.isNull(_columnIndexOfLoginMethod) ? null : _stmt.getText(_columnIndexOfLoginMethod);
                    _item.setLoginMethod(_tmpLoginMethod);
                    _result.add(_item);
                }
                ArrayList<EkoAccount> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<EkoAccount> getCurrentAccountFlowableImpl() {
        String _sql = "SELECT * from account  LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from account  LIMIT 1");){
                EkoAccount _result;
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfRefreshToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"refreshToken");
                int _columnIndexOfAccessToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessToken");
                int _columnIndexOfIssuedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"issuedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfAboutToExpireAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"aboutToExpireAt");
                int _columnIndexOfUserType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userType");
                int _columnIndexOfLoginMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"loginMethod");
                if (_stmt.step()) {
                    _result = new EkoAccount();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    _result.setDeviceId(_tmpDeviceId);
                    String _tmpRefreshToken = _stmt.isNull(_columnIndexOfRefreshToken) ? null : _stmt.getText(_columnIndexOfRefreshToken);
                    _result.setRefreshToken(_tmpRefreshToken);
                    String _tmpAccessToken = _stmt.isNull(_columnIndexOfAccessToken) ? null : _stmt.getText(_columnIndexOfAccessToken);
                    _result.setAccessToken(_tmpAccessToken);
                    String _tmp = _stmt.isNull(_columnIndexOfIssuedAt) ? null : _stmt.getText(_columnIndexOfIssuedAt);
                    DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setIssuedAt(_tmpIssuedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setExpiresAt(_tmpExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAboutToExpireAt) ? null : _stmt.getText(_columnIndexOfAboutToExpireAt);
                    DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setAboutToExpireAt(_tmpAboutToExpireAt);
                    String _tmpUserType = _stmt.isNull(_columnIndexOfUserType) ? null : _stmt.getText(_columnIndexOfUserType);
                    _result.setUserType(_tmpUserType);
                    String _tmpLoginMethod = _stmt.isNull(_columnIndexOfLoginMethod) ? null : _stmt.getText(_columnIndexOfLoginMethod);
                    _result.setLoginMethod(_tmpLoginMethod);
                } else {
                    _result = null;
                }
                EkoAccount ekoAccount = _result;
                return ekoAccount;
            }
        });
    }

    @Override
    public EkoAccount getCurrentAccountNow() {
        String _sql = "SELECT * from account LIMIT 1";
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from account LIMIT 1");){
                EkoAccount _result;
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfRefreshToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"refreshToken");
                int _columnIndexOfAccessToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessToken");
                int _columnIndexOfIssuedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"issuedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfAboutToExpireAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"aboutToExpireAt");
                int _columnIndexOfUserType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userType");
                int _columnIndexOfLoginMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"loginMethod");
                if (_stmt.step()) {
                    _result = new EkoAccount();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    _result.setDeviceId(_tmpDeviceId);
                    String _tmpRefreshToken = _stmt.isNull(_columnIndexOfRefreshToken) ? null : _stmt.getText(_columnIndexOfRefreshToken);
                    _result.setRefreshToken(_tmpRefreshToken);
                    String _tmpAccessToken = _stmt.isNull(_columnIndexOfAccessToken) ? null : _stmt.getText(_columnIndexOfAccessToken);
                    _result.setAccessToken(_tmpAccessToken);
                    String _tmp = _stmt.isNull(_columnIndexOfIssuedAt) ? null : _stmt.getText(_columnIndexOfIssuedAt);
                    DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setIssuedAt(_tmpIssuedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setExpiresAt(_tmpExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAboutToExpireAt) ? null : _stmt.getText(_columnIndexOfAboutToExpireAt);
                    DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setAboutToExpireAt(_tmpAboutToExpireAt);
                    String _tmpUserType = _stmt.isNull(_columnIndexOfUserType) ? null : _stmt.getText(_columnIndexOfUserType);
                    _result.setUserType(_tmpUserType);
                    String _tmpLoginMethod = _stmt.isNull(_columnIndexOfLoginMethod) ? null : _stmt.getText(_columnIndexOfLoginMethod);
                    _result.setLoginMethod(_tmpLoginMethod);
                } else {
                    _result = null;
                }
                EkoAccount ekoAccount = _result;
                return ekoAccount;
            }
        });
    }

    @Override
    EkoAccount getByIdNow(String userId) {
        String _sql = "SELECT * from account where userId = ? LIMIT 1";
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from account where userId = ? LIMIT 1");){
                EkoAccount _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfRefreshToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"refreshToken");
                int _columnIndexOfAccessToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessToken");
                int _columnIndexOfIssuedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"issuedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfAboutToExpireAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"aboutToExpireAt");
                int _columnIndexOfUserType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userType");
                int _columnIndexOfLoginMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"loginMethod");
                if (_stmt.step()) {
                    _result = new EkoAccount();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    _result.setDeviceId(_tmpDeviceId);
                    String _tmpRefreshToken = _stmt.isNull(_columnIndexOfRefreshToken) ? null : _stmt.getText(_columnIndexOfRefreshToken);
                    _result.setRefreshToken(_tmpRefreshToken);
                    String _tmpAccessToken = _stmt.isNull(_columnIndexOfAccessToken) ? null : _stmt.getText(_columnIndexOfAccessToken);
                    _result.setAccessToken(_tmpAccessToken);
                    String _tmp = _stmt.isNull(_columnIndexOfIssuedAt) ? null : _stmt.getText(_columnIndexOfIssuedAt);
                    DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setIssuedAt(_tmpIssuedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setExpiresAt(_tmpExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAboutToExpireAt) ? null : _stmt.getText(_columnIndexOfAboutToExpireAt);
                    DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setAboutToExpireAt(_tmpAboutToExpireAt);
                    String _tmpUserType = _stmt.isNull(_columnIndexOfUserType) ? null : _stmt.getText(_columnIndexOfUserType);
                    _result.setUserType(_tmpUserType);
                    String _tmpLoginMethod = _stmt.isNull(_columnIndexOfLoginMethod) ? null : _stmt.getText(_columnIndexOfLoginMethod);
                    _result.setLoginMethod(_tmpLoginMethod);
                } else {
                    _result = null;
                }
                EkoAccount ekoAccount = _result;
                return ekoAccount;
            }
        });
    }

    @Override
    EkoAccount getByUserTypeNow(String userType) {
        String _sql = "SELECT * from account where userType = ? LIMIT 1";
        return (EkoAccount)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from account where userType = ? LIMIT 1");){
                EkoAccount _result;
                int _argIndex = 1;
                if (userType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userType);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfRefreshToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"refreshToken");
                int _columnIndexOfAccessToken = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessToken");
                int _columnIndexOfIssuedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"issuedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfAboutToExpireAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"aboutToExpireAt");
                int _columnIndexOfUserType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userType");
                int _columnIndexOfLoginMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"loginMethod");
                if (_stmt.step()) {
                    _result = new EkoAccount();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    _result.setDeviceId(_tmpDeviceId);
                    String _tmpRefreshToken = _stmt.isNull(_columnIndexOfRefreshToken) ? null : _stmt.getText(_columnIndexOfRefreshToken);
                    _result.setRefreshToken(_tmpRefreshToken);
                    String _tmpAccessToken = _stmt.isNull(_columnIndexOfAccessToken) ? null : _stmt.getText(_columnIndexOfAccessToken);
                    _result.setAccessToken(_tmpAccessToken);
                    String _tmp = _stmt.isNull(_columnIndexOfIssuedAt) ? null : _stmt.getText(_columnIndexOfIssuedAt);
                    DateTime _tmpIssuedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setIssuedAt(_tmpIssuedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setExpiresAt(_tmpExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfAboutToExpireAt) ? null : _stmt.getText(_columnIndexOfAboutToExpireAt);
                    DateTime _tmpAboutToExpireAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setAboutToExpireAt(_tmpAboutToExpireAt);
                    String _tmpUserType = _stmt.isNull(_columnIndexOfUserType) ? null : _stmt.getText(_columnIndexOfUserType);
                    _result.setUserType(_tmpUserType);
                    String _tmpLoginMethod = _stmt.isNull(_columnIndexOfLoginMethod) ? null : _stmt.getText(_columnIndexOfLoginMethod);
                    _result.setLoginMethod(_tmpLoginMethod);
                } else {
                    _result = null;
                }
                EkoAccount ekoAccount = _result;
                return ekoAccount;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from account";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from account");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

