/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.amity.socialcloud.sdk.model.core.user.AmityUserType;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;

@Dao
public abstract class EkoAccountDao {
    @Query(value="SELECT * from account")
    public abstract Flowable<List<EkoAccount>> getAll();

    public Single<EkoAccount> getCurrentAccountSingle() {
        return this.getCurrentAccountFlowableImpl().firstOrError();
    }

    @Query(value="SELECT * from account  LIMIT 1")
    abstract Flowable<EkoAccount> getCurrentAccountFlowableImpl();

    @Query(value="SELECT * from account LIMIT 1")
    public abstract EkoAccount getCurrentAccountNow();

    @Insert(onConflict=1)
    abstract void insert(EkoAccount var1);

    @Update(onConflict=1)
    public abstract void update(EkoAccount var1);

    @Transaction
    public EkoAccount activateAccount(String userId, String accessToken) {
        return this.createAccountIfNeed(userId, accessToken);
    }

    @Transaction
    public EkoAccount activateVisitor() {
        return this.createVisitorAccountIfNeed();
    }

    @Transaction
    public EkoAccount deactivateAccount(String userId) {
        return this.createAccountIfNeed(userId);
    }

    @Transaction
    public void logoutAccount(String userId) {
        UserDatabase.get().clearAllTables();
        this.deleteAll();
    }

    private EkoAccount createAccountIfNeed(String userId) {
        return this.createAccountIfNeed(userId, null);
    }

    private EkoAccount createAccountIfNeed(String userId, String accessToken) {
        EkoAccount account = this.getByIdNow(userId);
        if (account == null) {
            account = EkoAccount.create(userId, accessToken);
            this.insert(account);
        } else if (accessToken != null) {
            account.setAccessToken(accessToken);
            this.update(account);
        }
        return account;
    }

    private EkoAccount createVisitorAccountIfNeed() {
        EkoAccount account = this.getByUserTypeNow(AmityUserType.VISITOR.getValue());
        if (account == null) {
            account = EkoAccount.create();
            this.insert(account);
        }
        return account;
    }

    @Delete
    public abstract void delete(EkoAccount var1);

    @Nullable
    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    abstract EkoAccount getByIdNow(String var1);

    @Nullable
    @Query(value="SELECT * from account where userType = :userType LIMIT 1")
    abstract EkoAccount getByUserTypeNow(String var1);

    @Query(value="DELETE from account")
    public abstract void deleteAll();
}

