/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import net.zetetic.database.sqlcipher.SupportOpenHelperFactory;

public final class RoomUtil {
    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable byte[] passphrase) {
        return RoomUtil.databaseBuilder(context, klass, name, passphrase, new Migration[0], -1);
    }

    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable byte[] passphrase, @NonNull Migration[] migrations) {
        return RoomUtil.databaseBuilder(context, klass, name, passphrase, migrations, -1);
    }

    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable byte[] passphrase, @NonNull Migration[] migrations, int fallbackFromVersion) {
        RoomDatabase.Builder builder = Room.databaseBuilder((Context)context, klass, (String)name);
        if (migrations.length > 0) {
            builder.addMigrations(migrations);
            if (fallbackFromVersion > 0) {
                int[] versionsToFallback = new int[fallbackFromVersion - 1];
                for (int i = 0; i < versionsToFallback.length; ++i) {
                    versionsToFallback[i] = i + 1;
                }
                if (versionsToFallback.length > 0) {
                    builder.fallbackToDestructiveMigrationFrom(versionsToFallback);
                }
            }
        } else {
            builder.fallbackToDestructiveMigration();
        }
        if (passphrase != null) {
            builder.openHelperFactory((SupportSQLiteOpenHelper.Factory)new SupportOpenHelperFactory(passphrase, null, false));
        }
        return builder;
    }

    private RoomUtil() {
    }
}

