/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import com.ekoapp.ekosdk.internal.data.RoomUtil;

abstract class BaseRoomDatabase
extends RoomDatabase {
    private static final Migration[] NO_MIGRATIONS = new Migration[0];

    BaseRoomDatabase() {
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, boolean allowMainThreadQueries, @Nullable byte[] passphrase) {
        return BaseRoomDatabase.init(context, klass, name, database, allowMainThreadQueries, passphrase, NO_MIGRATIONS, -1);
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, boolean allowMainThreadQueries, @Nullable byte[] passphrase, @NonNull Migration[] migrations) {
        return BaseRoomDatabase.init(context, klass, name, database, allowMainThreadQueries, passphrase, migrations, -1);
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, boolean allowMainThreadQueries, @Nullable byte[] passphrase, @NonNull Migration[] migrations, int fallbackFromVersion) {
        Context appContext = context.getApplicationContext();
        if (database != null) {
            database.close();
        }
        RoomDatabase.Builder<T> builder = RoomUtil.databaseBuilder(appContext, klass, name, passphrase, migrations, fallbackFromVersion);
        builder.setJournalMode(RoomDatabase.JournalMode.AUTOMATIC);
        if (allowMainThreadQueries) {
            builder.allowMainThreadQueries();
        }
        return (T)((Object)((BaseRoomDatabase)builder.build()));
    }
}

