/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.post.paging;

import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016JC\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator;", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "userId", "", "sortBy", "isDeleted", "", "dataTypes", "", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "tags", "includeMixedStructure", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;Z)V", "Ljava/lang/Boolean;", "toMap", "", "", "getFilterQuery", "getConditionStatement", "includeDeleted", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;Z)Ljava/lang/String;", "getPostTypesAsArrayString", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUserPostKeyCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserPostKeyCreator.kt\ncom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1878#2,3:103\n*S KotlinDebug\n*F\n+ 1 UserPostKeyCreator.kt\ncom/amity/socialcloud/sdk/social/data/post/paging/UserPostKeyCreator\n*L\n92#1:103,3\n*E\n"})
public final class UserPostKeyCreator
implements DynamicQueryStreamKeyCreator {
    @NotNull
    private final String userId;
    @NotNull
    private final String sortBy;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final List<AmityPost.DataType> dataTypes;
    @NotNull
    private final List<String> tags;
    private final boolean includeMixedStructure;

    public UserPostKeyCreator(@NotNull String userId, @NotNull String sortBy, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> dataTypes, @NotNull List<String> tags, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.userId = userId;
        this.sortBy = sortBy;
        this.isDeleted = isDeleted;
        this.dataTypes = dataTypes;
        this.tags = tags;
        this.includeMixedStructure = includeMixedStructure;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"targetId", (Object)this.userId);
        pairArray[1] = TuplesKt.to((Object)"targetType", (Object)AmityPost.TargetType.USER.getApiKey());
        pairArray[2] = TuplesKt.to((Object)"sortBy", (Object)this.sortBy);
        Boolean bl = this.isDeleted;
        pairArray[3] = TuplesKt.to((Object)"isDeleted", (Object)(bl != null ? bl : false));
        pairArray[4] = TuplesKt.to((Object)"dataTypes", (Object)PostRepositoryHelper.INSTANCE.convertPostTypesToString(this.dataTypes));
        pairArray[5] = TuplesKt.to((Object)"tags", (Object)CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        pairArray[6] = TuplesKt.to((Object)"includeMixedStructure", (Object)this.includeMixedStructure);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getFilterQuery() {
        return this.getConditionStatement(this.userId, this.isDeleted, this.dataTypes, this.tags, this.includeMixedStructure);
    }

    private final String getConditionStatement(String userId, Boolean includeDeleted, List<? extends AmityPost.DataType> dataTypes, List<String> tags, boolean includeMixedStructure) {
        Collection collection;
        String userFilterStatement = "post.targetType = '" + AmityPost.TargetType.USER.getApiKey() + "' and post.targetId = '" + userId + "'";
        String isDeletedFilterStatement = "";
        if (Intrinsics.areEqual((Object)includeDeleted, (Object)false)) {
            isDeletedFilterStatement = " and post.isDeleted = 0";
        } else if (Intrinsics.areEqual((Object)includeDeleted, (Object)true)) {
            isDeletedFilterStatement = " and post.isDeleted = 1";
        }
        Object postTypesFilterStatement = "";
        if (!((Collection)dataTypes).isEmpty()) {
            postTypesFilterStatement = " and post.postDataType IN (" + this.getPostTypesAsArrayString(dataTypes) + ")";
        }
        Object tagsFilterStatement = "";
        if (!((Collection)tags).isEmpty()) {
            tagsFilterStatement = " and " + CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)" and ", null, null, (int)0, null, UserPostKeyCreator::getConditionStatement$lambda$0, (int)30, null);
        }
        String structureTypeFilterStatement = "";
        if (!includeMixedStructure) {
            structureTypeFilterStatement = " and (post.structureType != 'mixed' OR post.structureType IS NULL)";
        }
        String parentPostFilter = (collection = (Collection)dataTypes) == null || collection.isEmpty() ? " and post.parentPostId is null" : " and post.targetId is not null";
        return userFilterStatement + isDeletedFilterStatement + (String)postTypesFilterStatement + (String)tagsFilterStatement + structureTypeFilterStatement + parentPostFilter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPostTypesAsArrayString(@NotNull List<? extends AmityPost.DataType> dataTypes) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        StringBuilder typesString = new StringBuilder();
        Iterable $this$forEachIndexed$iv = dataTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void dataType;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AmityPost.DataType dataType2 = (AmityPost.DataType)item$iv;
            int index = n;
            boolean bl = false;
            StringBuilder stringBuilder = index == 0 ? typesString.append("'" + dataType.getApiKey() + "'") : typesString.append(", '" + dataType.getApiKey() + "'");
        }
        String string = typesString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @Nullable
    public String optionalFilterQuery() {
        return DynamicQueryStreamKeyCreator.super.optionalFilterQuery();
    }

    private static final CharSequence getConditionStatement$lambda$0(String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return "post.tags LIKE '%\"" + tag + "\"%'";
    }
}

