/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.post.engine;

import com.amity.socialcloud.sdk.social.data.post.engine.CommentChangeTask;
import com.amity.socialcloud.sdk.social.data.post.engine.CommentChangeTracker;
import com.amity.socialcloud.sdk.social.data.post.engine.CreateTask;
import com.amity.socialcloud.sdk.social.data.post.engine.DeleteTask;
import com.amity.socialcloud.sdk.social.data.post.engine.ResetTask;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0010J\u0015\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/social/data/post/engine/PostCommentCountEngine;", "", "<init>", "()V", "BATCH_SIZE", "", "taskQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/amity/socialcloud/sdk/social/data/post/engine/CommentChangeTask;", "commentChangeTrackers", "", "", "Lcom/amity/socialcloud/sdk/social/data/post/engine/CommentChangeTracker;", "isProcessing", "", "queueCommentChangeTask", "", "task", "processCommentChangeTasks", "processResetTaskInternal", "Lcom/amity/socialcloud/sdk/social/data/post/engine/ResetTask;", "processCreateTaskInternal", "Lcom/amity/socialcloud/sdk/social/data/post/engine/CreateTask;", "processDeleteTaskInternal", "Lcom/amity/socialcloud/sdk/social/data/post/engine/DeleteTask;", "computeCommentCount", "postId", "publishUpdate", "clear", "getLocalCommentCount", "getLocalCommentCount$amity_sdk_release", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nPostCommentCountEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostCommentCountEngine.kt\ncom/amity/socialcloud/sdk/social/data/post/engine/PostCommentCountEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1869#2,2:223\n*S KotlinDebug\n*F\n+ 1 PostCommentCountEngine.kt\ncom/amity/socialcloud/sdk/social/data/post/engine/PostCommentCountEngine\n*L\n65#1:223,2\n*E\n"})
public final class PostCommentCountEngine {
    @NotNull
    public static final PostCommentCountEngine INSTANCE = new PostCommentCountEngine();
    private static final int BATCH_SIZE = 50;
    @NotNull
    private static final ConcurrentLinkedQueue<CommentChangeTask> taskQueue = new ConcurrentLinkedQueue();
    @NotNull
    private static final Map<String, CommentChangeTracker> commentChangeTrackers = new LinkedHashMap();
    private static boolean isProcessing;

    private PostCommentCountEngine() {
    }

    public final synchronized void queueCommentChangeTask(@NotNull CommentChangeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        taskQueue.add(task);
        this.processCommentChangeTasks();
    }

    private final synchronized void processCommentChangeTasks() {
        if (isProcessing) {
            return;
        }
        isProcessing = true;
        Set postsToUpdate = new LinkedHashSet();
        for (int processedCount = 0; processedCount < 50 && !((Collection)taskQueue).isEmpty() && taskQueue.poll() != null; ++processedCount) {
            CommentChangeTask task;
            String postId = task.getPostId();
            CommentChangeTask commentChangeTask = task;
            if (commentChangeTask instanceof ResetTask) {
                if (!this.processResetTaskInternal((ResetTask)task)) continue;
                postsToUpdate.add(postId);
                continue;
            }
            if (commentChangeTask instanceof CreateTask) {
                if (!this.processCreateTaskInternal((CreateTask)task)) continue;
                postsToUpdate.add(postId);
                continue;
            }
            if (commentChangeTask instanceof DeleteTask) {
                if (!this.processDeleteTaskInternal((DeleteTask)task)) continue;
                postsToUpdate.add(postId);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$forEach$iv = postsToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String postId = (String)element$iv;
            boolean bl = false;
            INSTANCE.publishUpdate(postId);
        }
        isProcessing = false;
        if (!((Collection)taskQueue).isEmpty()) {
            this.processCommentChangeTasks();
        }
    }

    private final boolean processResetTaskInternal(ResetTask task) {
        CommentChangeTracker tracker = new CommentChangeTracker(task.getLatestCreatedAt(), task.getServerCommentCount(), null, null, 12, null);
        commentChangeTrackers.put(task.getPostId(), tracker);
        return true;
    }

    private final boolean processCreateTaskInternal(CreateTask task) {
        CommentChangeTracker commentChangeTracker = commentChangeTrackers.get(task.getPostId());
        if (commentChangeTracker == null) {
            return false;
        }
        CommentChangeTracker tracker = commentChangeTracker;
        if (task.getCreatedAt().isBefore((ReadableInstant)tracker.getLatestCommentCreatedAt())) {
            return false;
        }
        if (tracker.getCreatedCommentIds().contains(task.getCommentId())) {
            return false;
        }
        tracker.getDeletedCommentIds().remove(task.getCommentId());
        tracker.getCreatedCommentIds().add(task.getCommentId());
        return true;
    }

    private final boolean processDeleteTaskInternal(DeleteTask task) {
        CommentChangeTracker commentChangeTracker = commentChangeTrackers.get(task.getPostId());
        if (commentChangeTracker == null) {
            return false;
        }
        CommentChangeTracker tracker = commentChangeTracker;
        if (tracker.getCreatedCommentIds().remove(task.getCommentId())) {
            return true;
        }
        if (tracker.getDeletedCommentIds().contains(task.getCommentId())) {
            return false;
        }
        tracker.getDeletedCommentIds().add(task.getCommentId());
        return true;
    }

    private final int computeCommentCount(String postId) {
        CommentChangeTracker commentChangeTracker = commentChangeTrackers.get(postId);
        if (commentChangeTracker == null) {
            return 0;
        }
        CommentChangeTracker tracker = commentChangeTracker;
        int count = tracker.getServerCommentCount() + tracker.getCreatedCommentIds().size() - tracker.getDeletedCommentIds().size();
        return Math.max(0, count);
    }

    private final void publishUpdate(String postId) {
        int localCommentCount = this.computeCommentCount(postId);
        UserDatabase.get().postDao().updateLocalCommentCount(postId, localCommentCount);
    }

    public final synchronized void clear() {
        taskQueue.clear();
        commentChangeTrackers.clear();
        isProcessing = false;
    }

    public final int getLocalCommentCount$amity_sdk_release(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.computeCommentCount(postId);
    }
}

