/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.util;

import android.util.Base64;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.json.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/core/util/JwtTokenDecoder;", "", "<init>", "()V", "JWT_PARTS_COUNT", "", "PAYLOAD_INDEX", "decode", "Lcom/amity/socialcloud/sdk/core/util/JwtTokenDecoder$DecodedToken;", "token", "", "extractUserId", "jsonObject", "Lorg/json/JSONObject;", "decodeBase64", "encoded", "DecodedToken", "amity-sdk_release"})
public final class JwtTokenDecoder {
    @NotNull
    public static final JwtTokenDecoder INSTANCE = new JwtTokenDecoder();
    private static final int JWT_PARTS_COUNT = 3;
    private static final int PAYLOAD_INDEX = 1;

    private JwtTokenDecoder() {
    }

    @NotNull
    public final DecodedToken decode(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 3) {
                throw AmityException.Companion.create$default(AmityException.Companion, "Invalid JWT format: expected 3 parts, got " + parts.size(), null, AmityError.INVALID_PARAMETER, null, 8, null);
            }
            String payload = this.decodeBase64((String)parts.get(1));
            JSONObject jsonObject = new JSONObject(payload);
            String userId = this.extractUserId(jsonObject);
            DateTime issuedAt = jsonObject.has("iat") ? new DateTime(jsonObject.getLong("iat") * (long)1000) : null;
            DateTime expiresAt = jsonObject.has("exp") ? new DateTime(jsonObject.getLong("exp") * (long)1000) : null;
            return new DecodedToken(userId, issuedAt, expiresAt);
        }
        catch (AmityException e) {
            throw e;
        }
        catch (Exception e) {
            throw AmityException.Companion.create$default(AmityException.Companion, "Failed to decode JWT token: " + e.getMessage(), (Throwable)e, AmityError.INVALID_PARAMETER, null, 8, null);
        }
    }

    @NotNull
    public final String extractUserId(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return this.decode(token).getUserId();
    }

    private final String extractUserId(JSONObject jsonObject) {
        JSONObject userObject;
        if (jsonObject.has("user") && (userObject = jsonObject.optJSONObject("user")) != null) {
            String publicUserId = userObject.optString("publicUserId", "");
            Intrinsics.checkNotNull((Object)publicUserId);
            if (((CharSequence)publicUserId).length() > 0) {
                return publicUserId;
            }
            String userId = userObject.optString("userId", "");
            Intrinsics.checkNotNull((Object)userId);
            if (((CharSequence)userId).length() > 0) {
                return userId;
            }
        }
        String sub = jsonObject.optString("sub", "");
        Intrinsics.checkNotNull((Object)sub);
        if (((CharSequence)sub).length() > 0) {
            return sub;
        }
        String userId = jsonObject.optString("userId", "");
        Intrinsics.checkNotNull((Object)userId);
        if (((CharSequence)userId).length() > 0) {
            return userId;
        }
        throw AmityException.Companion.create$default(AmityException.Companion, "JWT token missing userId claim (tried 'user.publicUserId', 'user.userId', 'sub', 'userId')", null, AmityError.INVALID_PARAMETER, null, 8, null);
    }

    private final String decodeBase64(String encoded) {
        String base64 = StringsKt.replace$default((String)StringsKt.replace$default((String)encoded, (String)"-", (String)"+", (boolean)false, (int)4, null), (String)"_", (String)"/", (boolean)false, (int)4, null);
        Object paddedBase64 = switch (base64.length() % 4) {
            case 2 -> base64 + "==";
            case 3 -> base64 + "=";
            default -> base64;
        };
        byte[] decodedBytes = Base64.decode((String)paddedBase64, (int)0);
        Intrinsics.checkNotNull((Object)decodedBytes);
        return new String(decodedBytes, Charsets.UTF_8);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/amity/socialcloud/sdk/core/util/JwtTokenDecoder$DecodedToken;", "", "userId", "", "issuedAt", "Lorg/joda/time/DateTime;", "expiresAt", "<init>", "(Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;)V", "getUserId", "()Ljava/lang/String;", "getIssuedAt", "()Lorg/joda/time/DateTime;", "getExpiresAt", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class DecodedToken {
        @NotNull
        private final String userId;
        @Nullable
        private final DateTime issuedAt;
        @Nullable
        private final DateTime expiresAt;

        public DecodedToken(@NotNull String userId, @Nullable DateTime issuedAt, @Nullable DateTime expiresAt) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            this.userId = userId;
            this.issuedAt = issuedAt;
            this.expiresAt = expiresAt;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @Nullable
        public final DateTime getIssuedAt() {
            return this.issuedAt;
        }

        @Nullable
        public final DateTime getExpiresAt() {
            return this.expiresAt;
        }

        @NotNull
        public final String component1() {
            return this.userId;
        }

        @Nullable
        public final DateTime component2() {
            return this.issuedAt;
        }

        @Nullable
        public final DateTime component3() {
            return this.expiresAt;
        }

        @NotNull
        public final DecodedToken copy(@NotNull String userId, @Nullable DateTime issuedAt, @Nullable DateTime expiresAt) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return new DecodedToken(userId, issuedAt, expiresAt);
        }

        public static /* synthetic */ DecodedToken copy$default(DecodedToken decodedToken, String string, DateTime dateTime, DateTime dateTime2, int n, Object object) {
            if ((n & 1) != 0) {
                string = decodedToken.userId;
            }
            if ((n & 2) != 0) {
                dateTime = decodedToken.issuedAt;
            }
            if ((n & 4) != 0) {
                dateTime2 = decodedToken.expiresAt;
            }
            return decodedToken.copy(string, dateTime, dateTime2);
        }

        @NotNull
        public String toString() {
            return "DecodedToken(userId=" + this.userId + ", issuedAt=" + this.issuedAt + ", expiresAt=" + this.expiresAt + ")";
        }

        public int hashCode() {
            int result = this.userId.hashCode();
            result = result * 31 + (this.issuedAt == null ? 0 : this.issuedAt.hashCode());
            result = result * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecodedToken)) {
                return false;
            }
            DecodedToken decodedToken = (DecodedToken)other;
            if (!Intrinsics.areEqual((Object)this.userId, (Object)decodedToken.userId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.issuedAt, (Object)decodedToken.issuedAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiresAt, (Object)decodedToken.expiresAt);
        }
    }
}

