/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.component;

import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.session.AccessTokenRenewalImpl;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.session.AccessTokenHandler;
import com.amity.socialcloud.sdk.model.core.session.LoginMethod;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0012\u0010\u001f\u001a\u00020\u00162\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0011H\u0002J\b\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020\u0016H\u0002J\b\u0010(\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "getSessionHandler", "()Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "setSessionHandler", "(Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;)V", "currentRenewal", "Lcom/amity/socialcloud/sdk/core/session/AccessTokenRenewalImpl;", "lastFailedDateTime", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "onSessionStateChange", "", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "observeTokenEvent", "initiateRenewalIfNeeded", "isTokenExpired", "", "initiateAccessTokenHandlerRenewal", "initiateSessionHandlerRenewal", "initiateRenewal", "renewal", "canInitiateRenewal", "unableToRenewWithCurrentRenewal", "finishCurrentRenewal", "Companion", "amity-sdk_release"})
public final class TokenRenewalSessionComponent
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppEventBus appEventBus;
    @Nullable
    private SessionHandler sessionHandler;
    @Nullable
    private AccessTokenRenewalImpl currentRenewal;
    private DateTime lastFailedDateTime;
    @NotNull
    private static final String TAG = "TokenRenewalSessionComponent";

    public TokenRenewalSessionComponent(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.appEventBus = appEventBus;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
        this.observeTokenEvent();
    }

    @Nullable
    public final SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public final void setSessionHandler(@Nullable SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void handleTokenExpire() {
        this.finishCurrentRenewal();
    }

    private final void observeTokenEvent() {
        this.appEventBus.observe().filter((Predicate)observeTokenEvent.1.INSTANCE).doOnNext(new Consumer(this){
            final /* synthetic */ TokenRenewalSessionComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(AppEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TokenRenewalSessionComponent.access$initiateRenewalIfNeeded(this.this$0, event instanceof AppEvent.TokenExpire);
            }
        }).subscribe();
    }

    private final void initiateRenewalIfNeeded(boolean isTokenExpired) {
        if (!this.canInitiateRenewal()) {
            return;
        }
        LoginMethod loginMethod = CoreClient.INSTANCE.getLoginMethod();
        if (loginMethod == LoginMethod.ACCESS_TOKEN) {
            this.initiateAccessTokenHandlerRenewal(isTokenExpired);
        } else {
            this.initiateSessionHandlerRenewal();
        }
    }

    static /* synthetic */ void initiateRenewalIfNeeded$default(TokenRenewalSessionComponent tokenRenewalSessionComponent, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        tokenRenewalSessionComponent.initiateRenewalIfNeeded(bl);
    }

    private final void initiateAccessTokenHandlerRenewal(boolean isTokenExpired) {
        AccessTokenHandler handler = CoreClient.INSTANCE.getAccessTokenHandler$amity_sdk_release();
        if (handler == null) {
            Object[] objectArray = new Object[]{"AccessTokenHandler not set for accessToken login. Per spec REQ-039: HANDLER_NOT_SET"};
            AmityLog.INSTANCE.e(TAG, objectArray);
            AmityException error = AmityException.Companion.create$default(AmityException.Companion, "AccessTokenHandler not registered. Call setAccessTokenHandler() before loginWithAccessToken().", null, AmityError.HANDLER_NOT_SET, null, 8, null);
            this.appEventBus.publish(new AppEvent.TerminationCodeReceive(error));
            return;
        }
        String userId = new ActiveUserIdGetUseCase().execute();
        if (((CharSequence)userId).length() == 0) {
            Object[] objectArray = new Object[]{"No active userId found. Token renewal skipped."};
            AmityLog.INSTANCE.e(TAG, objectArray);
            return;
        }
        AppEventBus appEventBus = this.appEventBus;
        SessionLifeCycleEventBus sessionLifeCycleEventBus = this.getSessionLifeCycleEventBus();
        this.currentRenewal = new AccessTokenRenewalImpl(appEventBus, sessionLifeCycleEventBus, (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateAccessTokenHandlerRenewal$lambda$0(this)), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> TokenRenewalSessionComponent.initiateAccessTokenHandlerRenewal$lambda$1(this, arg_0)), (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateAccessTokenHandlerRenewal$lambda$2(this)));
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handler, userId, this, null){
            int label;
            final /* synthetic */ AccessTokenHandler $handler;
            final /* synthetic */ String $userId;
            final /* synthetic */ TokenRenewalSessionComponent this$0;
            {
                this.$handler = $handler;
                this.$userId = $userId;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$handler.onTokenRenew(this.$userId, (Continuation<? super String>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            newAccessToken = (String)v0;
                            var2_5 = CoreClient.INSTANCE.loginWithAccessToken(newAccessToken).build().submit().doOnComplete((Action)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent ), ()V)((TokenRenewalSessionComponent)this.this$0)).doOnError(new Consumer(this.this$0){
                                final /* synthetic */ TokenRenewalSessionComponent this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final void accept(Throwable throwable) {
                                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                                    AmityException amityError = AmityException.Companion.fromThrowable(throwable);
                                    if (amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode() || amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode()) {
                                        TokenRenewalSessionComponent.access$getAppEventBus$p(this.this$0).publish(new AppEvent.TerminationCodeReceive(amityError));
                                        TokenRenewalSessionComponent.access$finishCurrentRenewal(this.this$0);
                                    } else {
                                        TokenRenewalSessionComponent.access$unableToRenewWithCurrentRenewal(this.this$0);
                                    }
                                }
                            }).subscribe();
                            Intrinsics.checkNotNull((Object)var2_5);
                        }
                        catch (Exception e) {
                            var4_6 = new Object[]{"AccessTokenHandler.onTokenRenew failed: " + e.getMessage()};
                            AmityLog.INSTANCE.e("TokenRenewalSessionComponent", var4_6);
                            TokenRenewalSessionComponent.access$unableToRenewWithCurrentRenewal(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(TokenRenewalSessionComponent this$0) {
                TokenRenewalSessionComponent.access$getAppEventBus$p(this$0).publish(AppEvent.TokenRenewSuccess.INSTANCE);
                TokenRenewalSessionComponent.access$finishCurrentRenewal(this$0);
            }
        }), (int)3, null);
    }

    private final void initiateSessionHandlerRenewal() {
        block0: {
            AppEventBus appEventBus = this.appEventBus;
            SessionLifeCycleEventBus sessionLifeCycleEventBus = this.getSessionLifeCycleEventBus();
            AccessTokenRenewalImpl accessTokenRenewal = new AccessTokenRenewalImpl(appEventBus, sessionLifeCycleEventBus, (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateSessionHandlerRenewal$lambda$3(this)), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> TokenRenewalSessionComponent.initiateSessionHandlerRenewal$lambda$4(this, arg_0)), (Function0<Unit>)((Function0)() -> TokenRenewalSessionComponent.initiateSessionHandlerRenewal$lambda$5(this)));
            this.initiateRenewal(accessTokenRenewal);
            SessionHandler sessionHandler = this.sessionHandler;
            if (sessionHandler == null) break block0;
            sessionHandler.sessionWillRenewAccessToken(accessTokenRenewal);
        }
    }

    private final void initiateRenewal(AccessTokenRenewalImpl renewal) {
        this.currentRenewal = renewal;
    }

    private final boolean canInitiateRenewal() {
        if (this.currentRenewal != null) {
            return false;
        }
        Duration tenMinutes = Duration.standardMinutes((long)10L);
        return this.currentRenewal == null || !DateTime.now().isAfter((ReadableInstant)this.lastFailedDateTime.plus((ReadableDuration)tenMinutes));
    }

    private final void unableToRenewWithCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now();
    }

    private final void finishCurrentRenewal() {
        AccessTokenRenewalImpl accessTokenRenewalImpl = this.currentRenewal;
        if (accessTokenRenewalImpl != null) {
            accessTokenRenewalImpl.invalidate();
        }
        this.currentRenewal = null;
        this.lastFailedDateTime = DateTime.now().minus((ReadableDuration)Duration.standardDays((long)999L));
    }

    private static final Unit initiateAccessTokenHandlerRenewal$lambda$0(TokenRenewalSessionComponent this$0) {
        this$0.appEventBus.publish(AppEvent.TokenRenewSuccess.INSTANCE);
        this$0.finishCurrentRenewal();
        return Unit.INSTANCE;
    }

    private static final Unit initiateAccessTokenHandlerRenewal$lambda$1(TokenRenewalSessionComponent this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        AmityException amityError = AmityException.Companion.fromThrowable(throwable);
        if (amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode() || amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode()) {
            this$0.appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
            this$0.finishCurrentRenewal();
        } else {
            this$0.unableToRenewWithCurrentRenewal();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initiateAccessTokenHandlerRenewal$lambda$2(TokenRenewalSessionComponent this$0) {
        this$0.unableToRenewWithCurrentRenewal();
        return Unit.INSTANCE;
    }

    private static final Unit initiateSessionHandlerRenewal$lambda$3(TokenRenewalSessionComponent this$0) {
        this$0.appEventBus.publish(AppEvent.TokenRenewSuccess.INSTANCE);
        this$0.finishCurrentRenewal();
        return Unit.INSTANCE;
    }

    private static final Unit initiateSessionHandlerRenewal$lambda$4(TokenRenewalSessionComponent this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        AmityException amityError = AmityException.Companion.fromThrowable(throwable);
        if (amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode() || amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode()) {
            this$0.appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
            this$0.finishCurrentRenewal();
        } else {
            this$0.unableToRenewWithCurrentRenewal();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initiateSessionHandlerRenewal$lambda$5(TokenRenewalSessionComponent this$0) {
        this$0.unableToRenewWithCurrentRenewal();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$initiateRenewalIfNeeded(TokenRenewalSessionComponent $this, boolean isTokenExpired) {
        $this.initiateRenewalIfNeeded(isTokenExpired);
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(TokenRenewalSessionComponent $this) {
        return $this.appEventBus;
    }

    public static final /* synthetic */ void access$finishCurrentRenewal(TokenRenewalSessionComponent $this) {
        $this.finishCurrentRenewal();
    }

    public static final /* synthetic */ void access$unableToRenewWithCurrentRenewal(TokenRenewalSessionComponent $this) {
        $this.unableToRenewWithCurrentRenewal();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent$Companion;", "", "<init>", "()V", "TAG", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

