/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.domain.session;

import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LoginWithAccessTokenUseCase;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle;
import com.amity.socialcloud.sdk.core.util.JwtTokenDecoder;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fJZ\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002Jb\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0002J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u001a\u0010\u001a\u001a\u00020\u00182\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/amity/socialcloud/sdk/core/domain/session/LoginWithAccessTokenUseCase;", "", "<init>", "()V", "execute", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "accessToken", "", "authToken", "displayName", "handleSameUserReAuth", "userId", "issuedAt", "Lorg/joda/time/DateTime;", "expiresAt", "handleFreshOrDifferentUserLogin", "currentUserId", "handleLoggingIn", "loginCompletable", "Lio/reactivex/rxjava3/core/Completable;", "waitForLogoutCompletion", "verifyAndHandleUserChange", "amity-sdk_release"})
public final class LoginWithAccessTokenUseCase {
    @NotNull
    public final Single<EkoAccount> execute(@Nullable AppEventBus appEventBus, @Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull String accessToken, @Nullable String authToken, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        JwtTokenDecoder.DecodedToken decodedToken = null;
        try {
            decodedToken = JwtTokenDecoder.INSTANCE.decode(accessToken);
        }
        catch (Exception e) {
            Single single = Single.error((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"error(...)");
            return single;
        }
        String userId = decodedToken.getUserId();
        String currentUserId = new ActiveUserIdGetUseCase().execute();
        boolean isSameUser = ((CharSequence)currentUserId).length() > 0 && Intrinsics.areEqual((Object)userId, (Object)currentUserId);
        return isSameUser ? this.handleSameUserReAuth(appEventBus, sessionLifeCycleEventBus, accessToken, authToken, displayName, userId, decodedToken.getIssuedAt(), decodedToken.getExpiresAt()) : this.handleFreshOrDifferentUserLogin(appEventBus, sessionLifeCycleEventBus, accessToken, authToken, displayName, userId, decodedToken.getIssuedAt(), decodedToken.getExpiresAt(), currentUserId);
    }

    private final Single<EkoAccount> handleSameUserReAuth(AppEventBus appEventBus, SessionLifeCycleEventBus sessionLifeCycleEventBus, String accessToken, String authToken, String displayName, String userId, DateTime issuedAt, DateTime expiresAt) {
        Single single = new SessionRepository().loginWithAccessToken(userId, displayName, accessToken, authToken, issuedAt, expiresAt).andThen((SingleSource)Single.defer(LoginWithAccessTokenUseCase::handleSameUserReAuth$lambda$0)).doOnSuccess(new Consumer(sessionLifeCycleEventBus){
            final /* synthetic */ SessionLifeCycleEventBus $sessionLifeCycleEventBus;
            {
                this.$sessionLifeCycleEventBus = $sessionLifeCycleEventBus;
            }

            public final void accept(EkoAccount it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SessionLifeCycleEventBus sessionLifeCycleEventBus = this.$sessionLifeCycleEventBus;
                    if (sessionLifeCycleEventBus == null) break block0;
                    sessionLifeCycleEventBus.publish(new SessionLifeCycle.Establish(it));
                }
            }
        }).doOnError(new Consumer(appEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            {
                this.$appEventBus = $appEventBus;
            }

            public final void accept(Throwable it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AmityException amityError = AmityException.Companion.fromThrowable(it);
                    if (amityError.getCode() != AmityError.USER_IS_GLOBAL_BANNED.getCode() && amityError.getCode() != AmityError.UNAUTHORIZED_ERROR.getCode()) break block1;
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus != null) {
                        appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
                    }
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"doOnError(...)");
        return single;
    }

    private final Single<EkoAccount> handleFreshOrDifferentUserLogin(AppEventBus appEventBus, SessionLifeCycleEventBus sessionLifeCycleEventBus, String accessToken, String authToken, String displayName, String userId, DateTime issuedAt, DateTime expiresAt, String currentUserId) {
        Completable completable = this.verifyAndHandleUserChange(appEventBus, currentUserId).andThen((CompletableSource)Completable.defer(() -> LoginWithAccessTokenUseCase.handleFreshOrDifferentUserLogin$lambda$1(this))).andThen((CompletableSource)Completable.defer(() -> LoginWithAccessTokenUseCase.handleFreshOrDifferentUserLogin$lambda$2(appEventBus, userId, displayName, accessToken, authToken, issuedAt, expiresAt)));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        Completable loginCompletable = completable;
        return this.handleLoggingIn(appEventBus, sessionLifeCycleEventBus, loginCompletable);
    }

    private final Single<EkoAccount> handleLoggingIn(AppEventBus appEventBus, SessionLifeCycleEventBus sessionLifeCycleEventBus, Completable loginCompletable) {
        Single single = loginCompletable.andThen((SingleSource)Single.defer(LoginWithAccessTokenUseCase::handleLoggingIn$lambda$3)).doOnSuccess(new Consumer(appEventBus, sessionLifeCycleEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            final /* synthetic */ SessionLifeCycleEventBus $sessionLifeCycleEventBus;
            {
                this.$appEventBus = $appEventBus;
                this.$sessionLifeCycleEventBus = $sessionLifeCycleEventBus;
            }

            public final void accept(EkoAccount it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus != null) {
                        appEventBus.publish(AppEvent.LoginSuccess.INSTANCE);
                    }
                    SessionLifeCycleEventBus sessionLifeCycleEventBus = this.$sessionLifeCycleEventBus;
                    if (sessionLifeCycleEventBus == null) break block1;
                    sessionLifeCycleEventBus.publish(new SessionLifeCycle.Establish(it));
                }
            }
        }).doOnError(new Consumer(appEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            {
                this.$appEventBus = $appEventBus;
            }

            public final void accept(Throwable it) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AmityException amityError = AmityException.Companion.fromThrowable(it);
                        if (amityError.getCode() != AmityError.USER_IS_GLOBAL_BANNED.getCode() && amityError.getCode() != AmityError.UNAUTHORIZED_ERROR.getCode()) break block0;
                        AppEventBus appEventBus = this.$appEventBus;
                        if (appEventBus == null) break block1;
                        appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
                        break block1;
                    }
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus == null) break block1;
                    appEventBus.publish(AppEvent.LoginFail.INSTANCE);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"doOnError(...)");
        return single;
    }

    private final Completable waitForLogoutCompletion() {
        Completable completable = Flowable.interval((long)100L, (TimeUnit)TimeUnit.MILLISECONDS).filter((Predicate)waitForLogoutCompletion.1.INSTANCE).firstElement().ignoreElement().subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    private final Completable verifyAndHandleUserChange(AppEventBus appEventBus, String currentUserId) {
        Completable completable = Completable.fromCallable(() -> LoginWithAccessTokenUseCase.verifyAndHandleUserChange$lambda$4(currentUserId, appEventBus));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable(...)");
        return completable;
    }

    private static final SingleSource handleSameUserReAuth$lambda$0() {
        return (SingleSource)new SessionRepository().getCurrentAccount();
    }

    private static final CompletableSource handleFreshOrDifferentUserLogin$lambda$1(LoginWithAccessTokenUseCase this$0) {
        return (CompletableSource)this$0.waitForLogoutCompletion();
    }

    private static final CompletableSource handleFreshOrDifferentUserLogin$lambda$2(AppEventBus $appEventBus, String $userId, String $displayName, String $accessToken, String $authToken, DateTime $issuedAt, DateTime $expiresAt) {
        block0: {
            AppEventBus appEventBus = $appEventBus;
            if (appEventBus == null) break block0;
            appEventBus.publish(AppEvent.LoggingIn.INSTANCE);
        }
        return (CompletableSource)new SessionRepository().loginWithAccessToken($userId, $displayName, $accessToken, $authToken, $issuedAt, $expiresAt);
    }

    private static final SingleSource handleLoggingIn$lambda$3() {
        return (SingleSource)new SessionRepository().getCurrentAccount();
    }

    private static final Unit verifyAndHandleUserChange$lambda$4(String $currentUserId, AppEventBus $appEventBus) {
        block1: {
            if (!(((CharSequence)$currentUserId).length() > 0)) break block1;
            AppEventBus appEventBus = $appEventBus;
            if (appEventBus != null) {
                appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
            }
        }
        return Unit.INSTANCE;
    }
}

