/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import co.amity.rxbridge.SingleKt;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.session.LoginMethod;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.AmityUserType;
import com.amity.socialcloud.sdk.model.core.user.AmityUserTypeKt;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015JB\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0015J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\fJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eJ\u0006\u0010\u001f\u001a\u00020\fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eJ@\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020!2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011JD\u0010$\u001a\u00020\f2\u0006\u0010#\u001a\u00020!2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010'\u001a\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u0010\r\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J@\u0010)\u001a\u00020\f2\u0006\u0010#\u001a\u00020!2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010#\u001a\u00020!H\u0002J\u001a\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "<init>", "()V", "ABOUT_TO_EXPIRE_TRESHOLD", "", "getActiveUserId", "", "getVisitorDeviceId", "getActiveUserType", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUserType;", "login", "Lio/reactivex/rxjava3/core/Completable;", "userId", "displayName", "authToken", "isLegacyVersion", "", "loginVisitor", "authSignature", "authSignatureExpiresAt", "Lorg/joda/time/DateTime;", "loginWithAccessToken", "accessToken", "issuedAt", "expiresAt", "getLoginMethod", "Lcom/amity/socialcloud/sdk/model/core/session/LoginMethod;", "logout", "revokeAccessToken", "Lio/reactivex/rxjava3/core/Single;", "clearData", "getCurrentAccount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "renewToken", "account", "renewTokenForAccessTokenLogin", "tokenIssuedAt", "tokenExpiresAt", "activateAccount", "activateVisitor", "renewTokenIfNeed", "verifyCurrentAccessToken", "updateDisplayNameIfNeeded", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionRepository.kt\ncom/amity/socialcloud/sdk/core/data/session/SessionRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,380:1\n1#2:381\n*E\n"})
public final class SessionRepository
extends EkoObjectRepository {
    private final double ABOUT_TO_EXPIRE_TRESHOLD;

    public SessionRepository() {
        this.ABOUT_TO_EXPIRE_TRESHOLD = 0.8;
    }

    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final String getVisitorDeviceId() {
        return new SessionLocalDataStore().getVisitorDeviceId();
    }

    @NotNull
    public final AmityUserType getActiveUserType() {
        return new SessionLocalDataStore().getActiveUserType();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = SessionRepository.activateAccount$default(this, userId, null, 2, null).flatMapCompletable(new Function(this, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            public final CompletableSource apply(EkoAccount account) {
                Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                account.setLoginMethod(LoginMethod.USER_ID.getValue());
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, account, this.$displayName, this.$authToken, null, null, this.$isLegacyVersion);
            }
        }).doOnComplete(() -> SessionRepository.login$lambda$0(this, userId, displayName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnComplete(...)");
        return completable;
    }

    @NotNull
    public final Completable loginVisitor(@Nullable String displayName, @Nullable String authSignature, @Nullable DateTime authSignatureExpiresAt) {
        Completable completable = this.activateVisitor().flatMapCompletable(new Function(this, displayName, authSignature, authSignatureExpiresAt){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
            }

            public final CompletableSource apply(EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, it, this.$displayName, null, this.$authSignature, this.$authSignatureExpiresAt, false);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable loginWithAccessToken(@NotNull String userId, @Nullable String displayName, @NotNull String accessToken, @Nullable String authToken, @Nullable DateTime issuedAt, @Nullable DateTime expiresAt) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Completable completable = this.activateAccount(userId, accessToken).flatMapCompletable(new Function(this, displayName, accessToken, authToken, issuedAt, expiresAt){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $accessToken;
            final /* synthetic */ String $authToken;
            final /* synthetic */ DateTime $issuedAt;
            final /* synthetic */ DateTime $expiresAt;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$accessToken = $accessToken;
                this.$authToken = $authToken;
                this.$issuedAt = $issuedAt;
                this.$expiresAt = $expiresAt;
            }

            public final CompletableSource apply(EkoAccount account) {
                Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                account.setLoginMethod(LoginMethod.ACCESS_TOKEN.getValue());
                return (CompletableSource)SessionRepository.access$renewTokenForAccessTokenLogin(this.this$0, account, this.$displayName, this.$accessToken, this.$authToken, this.$issuedAt, this.$expiresAt);
            }
        }).doOnComplete(() -> SessionRepository.loginWithAccessToken$lambda$1(this, userId, displayName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnComplete(...)");
        return completable;
    }

    public static /* synthetic */ Completable loginWithAccessToken$default(SessionRepository sessionRepository, String string, String string2, String string3, String string4, DateTime dateTime, DateTime dateTime2, int n, Object object) {
        if ((n & 0x10) != 0) {
            dateTime = null;
        }
        if ((n & 0x20) != 0) {
            dateTime2 = null;
        }
        return sessionRepository.loginWithAccessToken(string, string2, string3, string4, dateTime, dateTime2);
    }

    @Nullable
    public final LoginMethod getLoginMethod() {
        LoginMethod loginMethod;
        EkoAccount account = new SessionLocalDataStore().getCurrentAccount();
        Object object = account;
        if (object != null && (object = ((EkoAccount)object).getLoginMethod()) != null) {
            Object it = object;
            boolean bl = false;
            loginMethod = LoginMethod.Companion.fromValue((String)it);
        } else {
            loginMethod = null;
        }
        return loginMethod;
    }

    @NotNull
    public final Completable logout() {
        Completable completable = Completable.fromAction(SessionRepository::logout$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Single<Boolean> revokeAccessToken() {
        return new SessionRemoteDataStore().revokeAccessToken();
    }

    @NotNull
    public final Completable clearData() {
        Completable completable = new DeviceNotificationRepository().unregisterAll().andThen((CompletableSource)Completable.fromAction(SessionRepository::clearData$lambda$4).subscribeOn(Schedulers.io()));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        return completable;
    }

    @NotNull
    public final Single<EkoAccount> getCurrentAccount() {
        Single single = Single.create(SessionRepository::getCurrentAccount$lambda$5).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    @NotNull
    public final Completable renewToken(@NotNull EkoAccount account, @Nullable String displayName, @Nullable String authToken, @Nullable String authSignature, @Nullable DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account, displayName, authSignature, authSignatureExpiresAt, authToken, isLegacyVersion, this){
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            final /* synthetic */ SessionRepository this$0;
            {
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(EkoApiKey it) {
                Single<RegisterDeviceDto> single;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityUserTypeKt.isVisitor(this.$account)) {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    String string2 = this.$account.getDeviceId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceId(...)");
                    single = sessionRemoteDataStore.registerVisitor(string, this.$displayName, string2, this.$authSignature, this.$authSignatureExpiresAt);
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    String string3 = this.$account.getUserId();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserId(...)");
                    String string4 = this.$account.getDeviceId();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDeviceId(...)");
                    single = sessionRemoteDataStore.registerDevice(string, string3, this.$displayName, string4, this.$authToken, this.$isLegacyVersion);
                }
                io.reactivex.Single single2 = SingleKt.toRx2(single).retryWhen(RetryWhen.retryIf(renewToken.1::apply$lambda$0).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build());
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"retryWhen(...)");
                return (CompletableSource)SingleKt.toRx3((io.reactivex.Single)single2).flatMapCompletable(new Function(this.$account, this.$isLegacyVersion, this.this$0){
                    final /* synthetic */ EkoAccount $account;
                    final /* synthetic */ boolean $isLegacyVersion;
                    final /* synthetic */ SessionRepository this$0;
                    {
                        this.$account = $account;
                        this.$isLegacyVersion = $isLegacyVersion;
                        this.this$0 = $receiver;
                    }

                    public final CompletableSource apply(RegisterDeviceDto it) {
                        EkoUserListDto ekoUserListDto;
                        this.$account.setRefreshToken(it.getRefreshToken());
                        this.$account.setAccessToken(it.getAccessToken());
                        if (this.$isLegacyVersion) {
                            this.$account.setIssuedAt(DateTime.now());
                            this.$account.setExpiresAt(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L)));
                        } else {
                            this.$account.setIssuedAt(it.getIssuedAt());
                            this.$account.setExpiresAt(it.getExpiresAt());
                        }
                        double tokenDuration = (double)(this.$account.getExpiresAt().getMillis() - this.$account.getIssuedAt().getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * SessionRepository.access$getABOUT_TO_EXPIRE_TRESHOLD$p(this.this$0);
                        this.$account.setAboutToExpireAt(this.$account.getIssuedAt().plus((long)tokenDuration));
                        Object[] objectArray = new Object[]{"token renewed: account updated : \n       expiresAt = " + this.$account.getExpiresAt() + " \naboutToExpireAt = " + this.$account.getAboutToExpireAt() + "\n       issuedAt = " + this.$account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "};
                        AmityLog.INSTANCE.e("SSM3", objectArray);
                        EkoUserListDto $this$apply_u24lambda_u240 = ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        List list = it.getUsers();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setUsers(list);
                        List list2 = it.getFiles();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setFiles(list2);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                }).doOnError(new Consumer(this.$account){
                    final /* synthetic */ EkoAccount $account;
                    {
                        this.$account = $account;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
                        String string = this.$account.getUserId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserId(...)");
                        sessionLocalDataStore.logoutAccount(string);
                    }
                });
            }

            private static final boolean apply$lambda$0(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) != AmityError.USER_IS_GLOBAL_BANNED;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    public static /* synthetic */ Completable renewToken$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, String string3, DateTime dateTime, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sessionRepository.renewToken(ekoAccount, string, string2, string3, dateTime, bl);
    }

    private final Completable renewTokenForAccessTokenLogin(EkoAccount account, String displayName, String accessToken, String authToken, DateTime tokenIssuedAt, DateTime tokenExpiresAt) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(accessToken, account, displayName, authToken, tokenIssuedAt, tokenExpiresAt, this){
            final /* synthetic */ String $accessToken;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ DateTime $tokenIssuedAt;
            final /* synthetic */ DateTime $tokenExpiresAt;
            final /* synthetic */ SessionRepository this$0;
            {
                this.$accessToken = $accessToken;
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$tokenIssuedAt = $tokenIssuedAt;
                this.$tokenExpiresAt = $tokenExpiresAt;
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(EkoApiKey apiKey) {
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                String string = apiKey.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                Completable completable = sessionRemoteDataStore.verifyAccessToken(string, this.$accessToken);
                SessionRemoteDataStore sessionRemoteDataStore2 = new SessionRemoteDataStore();
                String string2 = apiKey.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApiKey(...)");
                String string3 = this.$account.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserId(...)");
                String string4 = this.$account.getDeviceId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDeviceId(...)");
                io.reactivex.Single single = SingleKt.toRx2(sessionRemoteDataStore2.registerDevice(string2, string3, this.$displayName, string4, this.$authToken, false)).retryWhen(RetryWhen.retryIf(renewTokenForAccessTokenLogin.1::apply$lambda$0).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build());
                Intrinsics.checkNotNullExpressionValue((Object)single, (String)"retryWhen(...)");
                return (CompletableSource)completable.andThen((CompletableSource)SingleKt.toRx3((io.reactivex.Single)single).flatMapCompletable(new Function(this.$account, this.$tokenIssuedAt, this.$tokenExpiresAt, this.this$0){
                    final /* synthetic */ EkoAccount $account;
                    final /* synthetic */ DateTime $tokenIssuedAt;
                    final /* synthetic */ DateTime $tokenExpiresAt;
                    final /* synthetic */ SessionRepository this$0;
                    {
                        this.$account = $account;
                        this.$tokenIssuedAt = $tokenIssuedAt;
                        this.$tokenExpiresAt = $tokenExpiresAt;
                        this.this$0 = $receiver;
                    }

                    public final CompletableSource apply(RegisterDeviceDto response) {
                        EkoUserListDto ekoUserListDto;
                        this.$account.setRefreshToken(response.getRefreshToken());
                        this.$account.setAccessToken(response.getAccessToken());
                        DateTime dateTime = this.$tokenIssuedAt;
                        if (dateTime == null) {
                            dateTime = response.getIssuedAt();
                        }
                        this.$account.setIssuedAt(dateTime);
                        DateTime dateTime2 = this.$tokenExpiresAt;
                        if (dateTime2 == null) {
                            dateTime2 = response.getExpiresAt();
                        }
                        this.$account.setExpiresAt(dateTime2);
                        this.$account.setLoginMethod(LoginMethod.ACCESS_TOKEN.getValue());
                        double tokenDuration = (double)(this.$account.getExpiresAt().getMillis() - this.$account.getIssuedAt().getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * SessionRepository.access$getABOUT_TO_EXPIRE_TRESHOLD$p(this.this$0);
                        this.$account.setAboutToExpireAt(this.$account.getIssuedAt().plus((long)tokenDuration));
                        Object[] objectArray = new Object[]{"access token login: account updated : \n       expiresAt = " + this.$account.getExpiresAt() + " \naboutToExpireAt = " + this.$account.getAboutToExpireAt() + "\n       issuedAt = " + this.$account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "};
                        AmityLog.INSTANCE.e("SSM3", objectArray);
                        EkoUserListDto $this$apply_u24lambda_u240 = ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        List list = response.getUsers();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setUsers(list);
                        List list2 = response.getFiles();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setFiles(list2);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                })).doOnError(new Consumer(this.$account){
                    final /* synthetic */ EkoAccount $account;
                    {
                        this.$account = $account;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
                        String string = this.$account.getUserId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserId(...)");
                        sessionLocalDataStore.logoutAccount(string);
                    }
                });
            }

            private static final boolean apply$lambda$0(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) != AmityError.USER_IS_GLOBAL_BANNED;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    static /* synthetic */ Completable renewTokenForAccessTokenLogin$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, String string3, DateTime dateTime, DateTime dateTime2, int n, Object object) {
        if ((n & 0x10) != 0) {
            dateTime = null;
        }
        if ((n & 0x20) != 0) {
            dateTime2 = null;
        }
        return sessionRepository.renewTokenForAccessTokenLogin(ekoAccount, string, string2, string3, dateTime, dateTime2);
    }

    private final Single<EkoAccount> activateAccount(String userId, String accessToken) {
        Single single = Single.fromCallable(() -> SessionRepository.activateAccount$lambda$6(userId, accessToken)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    static /* synthetic */ Single activateAccount$default(SessionRepository sessionRepository, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return sessionRepository.activateAccount(string, string2);
    }

    private final Single<EkoAccount> activateVisitor() {
        Single single = Single.fromCallable(SessionRepository::activateVisitor$lambda$7).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    private final Completable renewTokenIfNeed(EkoAccount account, String displayName, String authToken, String authSignature, DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext(new Function(this, account, displayName, authToken, authSignature, authSignatureExpiresAt, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            public final CompletableSource apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)this.this$0.renewToken(this.$account, this.$displayName, this.$authToken, this.$authSignature, this.$authSignatureExpiresAt, this.$isLegacyVersion);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account){
            final /* synthetic */ EkoAccount $account;
            {
                this.$account = $account;
            }

            public final CompletableSource apply(EkoApiKey it) {
                CompletableSource completableSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$account.getAccessToken() == null) {
                    completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "accessToken not found", null, AmityError.UNAUTHORIZED_ERROR, null, 8, null));
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    completableSource = (CompletableSource)SessionRemoteDataStore.verifyAccessToken$default(sessionRemoteDataStore, string, null, 2, null);
                }
                return completableSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observe(userId).firstOrError().flatMapCompletable(new Function(displayName, userId){
                final /* synthetic */ String $displayName;
                final /* synthetic */ String $userId;
                {
                    this.$displayName = $displayName;
                    this.$userId = $userId;
                }

                public final CompletableSource apply(AmityUser it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser(this.$userId, new UserUpdateOption(this.$displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
                }
            }).subscribeOn(Schedulers.io()).doOnError((Consumer)updateDisplayNameIfNeeded.2.INSTANCE).subscribe();
        }
    }

    private static final void login$lambda$0(SessionRepository this$0, String $userId, String $displayName) {
        this$0.updateDisplayNameIfNeeded($userId, $displayName);
    }

    private static final void loginWithAccessToken$lambda$1(SessionRepository this$0, String $userId, String $displayName) {
        this$0.updateDisplayNameIfNeeded($userId, $displayName);
    }

    private static final void logout$lambda$3() {
        CoreClient.INSTANCE.publishLogoutEvent();
    }

    private static final void clearData$lambda$4() {
        new SessionLocalDataStore().logoutAccount(new SessionLocalDataStore().getActiveUserId());
    }

    private static final void getCurrentAccount$lambda$5(SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EkoAccount account = new SessionLocalDataStore().getCurrentAccount();
        if (account != null) {
            it.onSuccess((Object)account);
        } else {
            it.onError((Throwable)EntityNotFoundException.INSTANCE);
        }
    }

    private static final EkoAccount activateAccount$lambda$6(String $userId, String $accessToken) {
        return new SessionLocalDataStore().activateAccount($userId, $accessToken);
    }

    private static final EkoAccount activateVisitor$lambda$7() {
        return new SessionLocalDataStore().activateVisitorAccount();
    }

    public static final /* synthetic */ Completable access$renewTokenIfNeed(SessionRepository $this, EkoAccount account, String displayName, String authToken, String authSignature, DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        return $this.renewTokenIfNeed(account, displayName, authToken, authSignature, authSignatureExpiresAt, isLegacyVersion);
    }

    public static final /* synthetic */ Completable access$renewTokenForAccessTokenLogin(SessionRepository $this, EkoAccount account, String displayName, String accessToken, String authToken, DateTime tokenIssuedAt, DateTime tokenExpiresAt) {
        return $this.renewTokenForAccessTokenLogin(account, displayName, accessToken, authToken, tokenIssuedAt, tokenExpiresAt);
    }

    public static final /* synthetic */ double access$getABOUT_TO_EXPIRE_TRESHOLD$p(SessionRepository $this) {
        return $this.ABOUT_TO_EXPIRE_TRESHOLD;
    }
}

