package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedSortOption
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetCommunityPostPagingDataUseCase {

    fun execute(
        communityId: String,
        sortOption: AmityCommunityFeedSortOption,
        isDeleted: Boolean?,
        feedType: AmityFeedType,
        dataTypes: List<AmityPost.DataType>,
        tags: List<String>,
        matchingOnlyParentPosts: Boolean,
        includeMixedStructure: Boolean
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().getCommunityPostPagingData(
            communityId = communityId,
            sortOption = sortOption,
            feedType = feedType,
            isDeleted = isDeleted,
            dataTypes = dataTypes,
            tags = tags,
            matchingOnlyParentPosts = matchingOnlyParentPosts,
            includeMixedStructure = includeMixedStructure
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                PostComposerUseCase().execute(post)
            }
        }
    }
}