package com.ekoapp.ekosdk.internal.data.model;

import static com.ekoapp.ekosdk.internal.util.EkoPreconditions.checkValidId;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;

import com.amity.socialcloud.sdk.model.core.user.AmityUserType;
import com.google.common.base.MoreObjects;

import org.joda.time.DateTime;

import java.util.UUID;

@Entity(tableName = "account")
public class EkoAccount {

    @PrimaryKey
    @NonNull
    private String userId;
    private String deviceId;
    private String refreshToken;
    private String accessToken;
    private DateTime issuedAt;
    private DateTime expiresAt;
    private DateTime aboutToExpireAt;
    private String userType;
    private String loginMethod;

    @NonNull
    public String getUserId() {
        return userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = checkValidId(userId, "userId");
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DateTime getIssuedAt() {
        return issuedAt;
    }

    public void setIssuedAt(DateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public DateTime getExpiresAt() {
        return expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public DateTime getAboutToExpireAt() {
        return aboutToExpireAt;
    }

    public void setAboutToExpireAt(DateTime aboutToExpireAt) {
        this.aboutToExpireAt = aboutToExpireAt;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getLoginMethod() {
        return loginMethod;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("userId", userId)
                .add("deviceId", deviceId)
                .add("refreshToken", refreshToken)
                .add("issuedAt", issuedAt.getMillis())
                .add("expiresAt", expiresAt.getMillis())
                .add("aboutToExpireAt", aboutToExpireAt.getMillis())
                .add("userType", userType)
                .add("loginMethod", loginMethod)
                .toString();
    }

    public static EkoAccount create(@NonNull String userId) {
        return create(userId, null);
    }

    public static EkoAccount create(@NonNull String userId, String accessToken) {
        EkoAccount account = new EkoAccount();
        account.setUserId(userId);
        if (accessToken != null) {
            account.setAccessToken(accessToken);
        }
        account.setUserType(AmityUserType.SIGNED_IN.getValue());
        account.setDeviceId(UUID.randomUUID().toString());
        return account;
    }

    public static EkoAccount create() {
        EkoAccount account = new EkoAccount();
        String deviceId = UUID.randomUUID().toString();
        account.setUserId(deviceId);
        account.setUserType(AmityUserType.VISITOR.getValue());
        account.setDeviceId(deviceId);
        return account;
    }
}
