package com.ekoapp.ekosdk.internal.data.migration;

import androidx.annotation.NonNull;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;

/**
 * Database migrations for EkoDatabase.
 *
 * Migration history:
 * - Version 11 → 12: Added loginMethod column to account table for Login with Access Token feature
 */
public final class EkoDatabaseMigrations {

    private EkoDatabaseMigrations() { /* NO INSTANCE */ }

    /**
     * The first version that has a migration defined.
     * Versions before this will use fallbackToDestructiveMigration.
     */
    public static final int FIRST_MIGRATION_VERSION = 11;

    /**
     * Migration from version 11 to 12.
     * Adds loginMethod column to the account table to track authentication method (userId vs accessToken).
     */
    public static final Migration MIGRATION_11_12 = new Migration(11, 12) {
        @Override
        public void migrate(@NonNull SupportSQLiteDatabase database) {
            // Add loginMethod column to account table
            // Default value is NULL for existing users (will be treated as userId login)
            database.execSQL("ALTER TABLE account ADD COLUMN loginMethod TEXT");
        }
    };

    /**
     * Returns all migrations for EkoDatabase.
     */
    public static Migration[] getAllMigrations() {
        return new Migration[] {
                MIGRATION_11_12
        };
    }
}
