package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedSortOption
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.amity.socialcloud.sdk.social.data.post.paging.CommunityPostKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityCommunityPostPagingDao : DynamicQueryStreamPagingDao<PostEntity> {

    @RawQuery(observedEntities = [PostEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PostEntity>

    fun getCommunityPostPagingSource(
        communityId: String,
        feedType: AmityFeedType,
        isDeleted: Boolean?,
        sortBy: String,
        postTypes: List<AmityPost.DataType>,
        tags: List<String>,
        matchingOnlyParentPosts: Boolean,
        includeMixedStructure: Boolean,
    ): PagingSource<Int, PostEntity> {
        val order = if (AmityCommunityFeedSortOption.LAST_CREATED.apiKey == sortBy)
            AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "post",
                primaryKeyColumnName = "postId",
                nonce = AmityNonce.COMMUNITY_FEED,
                sortColumn = "createdAt",
                order = order,
                dynamicQueryStreamKeyCreator = CommunityPostKeyCreator(
                    communityId = communityId,
                    sortBy = sortBy,
                    isDeleted = isDeleted,
                    feedType = feedType,
                    dataTypes = postTypes,
                    tags = tags,
                    matchingOnlyParentPosts = matchingOnlyParentPosts,
                    includeMixedStructure = includeMixedStructure
                )
            )
        )
    }


}