package com.amity.socialcloud.sdk.social.domain.post.create

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.file.AmityClip
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostCreateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class ClipPostCreateUseCase : PostCreateUseCase {

    fun execute(
        targetType: String,
        targetId: String,
        clip: AmityClip,
        text: String,
        displayMode: AmityClip.DisplayMode,
        isMuted: Boolean = false,
        metadata: JsonObject?,
        mentionUserIds: List<String>?,
        hashtags: List<String>?,
        tags: List<String>? = null,
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = composeData(text),
            attachments = mapAttachments(
                files = listOf(clip),
                dataType = AmityPost.DataType.CLIP.getApiKey(),
                fileId = clip.getFileId(),
                displayMode = displayMode.apiString,
                isMuted = isMuted
            ),
            metadata = metadata,
            mentionees = mapMentionees(mentionUserIds),
            hashtags = hashtags,
            tags = tags,
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(
                    AmityException.create(
                        "Post not found",
                        null,
                        AmityError.ITEM_NOT_FOUND
                    )
                )
            }
        }
    }

    private fun composeData(
        text: String,
    ): JsonObject {
        return JsonObject().apply {
            addProperty("text", text)
        }
    }

}