package com.amity.socialcloud.sdk.social.data.post

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.ekoapp.ekosdk.internal.util.LinkUtils
import com.ekoapp.ekosdk.internal.util.PIIUtils

internal class PostEntityMapper : EntityMapper<EkoPostDto, PostEntity>() {

    override fun map(list: List<EkoPostDto>): List<PostEntity> {
        return list.map {
            map(it)
        }
    }

    private fun map(dto: EkoPostDto): PostEntity {
        return PostEntity().apply {
            postId = dto.postId
            mid = dto.mid
            path = dto.getPath()
            targetType = dto.targetType
            targetId = dto.targetId
            parentPostId = dto.parentPostId
            postedUserId = dto.postedUserId
            sharedUserId = dto.sharedUserId
            postDataType = dto.dataType
            data = dto.getData() ?: JsonObject()
            metadata = dto.getMetadata()
            sharedCount = dto.sharedCount
            structureType = dto.structureType ?: ""
            reactions = if (dto.reactions == null) AmityReactionMap() else dto.reactions
            reactionCount = dto.reactionCount
            flagCount = dto.flagCount
            commentCount = dto.commentsCount
            localCommentCount = dto.commentsCount
            childPostIds = dto.children
            isDeleted = dto.deleted
            feedType = dto.feedType
            editedAt = dto.editedAt
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
            dto.mentionees?.let { mentionees = it }
            impression = dto.impression
            reach = dto.reach
            dto.hashtags?.let { hashtags = it }
            dto.tags?.let { tags = it }
            dto.pii?.let { piiDtos ->
                pii = PIIUtils.convertDtosToJsonArray(piiDtos)
            }
            dto.links?.let { linkDtos ->
                links = LinkUtils.convertDtosToJsonArray(linkDtos)
            }
        }
    }

}