package com.amity.socialcloud.sdk.social.data.event.paging

import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class EventResponseQueryKeyCreator(
    private val eventId: String,
    private val status: AmityEventResponseStatus?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        val map = mutableMapOf<String, Any>()
        
        map["eventId"] = eventId
        status?.let { map["status"] = it.apiKey }
        
        return map
    }

    override fun getFilterQuery(): String {
        val filters = mutableListOf<String>()
        
        filters.add("eventId = '$eventId'")
        status?.let { 
            filters.add("status = '${it.apiKey}'") 
        }
        
        return filters.joinToString(" AND ")
    }
}
