package com.amity.socialcloud.sdk.model.core.session

/**
 * Represents the method used to authenticate the user.
 */
enum class LoginMethod(val value: String) {
    /**
     * User authenticated using userId (traditional login flow)
     */
    USER_ID("userId"),

    /**
     * User authenticated using customer-provided JWT access token
     */
    ACCESS_TOKEN("accessToken");

    companion object {
        fun fromValue(value: String?): LoginMethod? {
            return entries.find { it.value == value }
        }
    }
}
