package com.amity.socialcloud.sdk.model.core.error

import com.amity.socialcloud.sdk.log.AmityLog

enum class AmityError(val code: Int) {
    // Server Errors
    BUSINESS_ERROR(500000), UNAUTHORIZED_ERROR(400100), ITEM_NOT_FOUND(400400),
    BAD_REQUEST_ERROR(400000), INVALID_REGULAR_EXPRESSION(400001), VIDEO_FORMAT_INVALID(400002),
    CONFLICT(400900), FORBIDDEN_ERROR(400300), PERMISSION_DENIED(400301), USER_IS_MUTED(400302),
    CHANNEL_IS_MUTED(400303), USER_IS_BANNED(400304), NUMBER_OF_MEMBER_EXCEED(400305),
    EXEMPT_FROM_BAN(400306), MAX_REPETITION_EXCEED(400307), BAN_WORD_FOUND(400308),
    LINK_NOT_ALLOWED(400309), TOO_MANY_MEMBER_ERROR(400310), RPC_RATE_LIMIT_ERROR(400311),
    USER_IS_GLOBAL_BANNED(400312), USER_IS_LAST_MODERATOR(400317), USER_IS_LAST_MEMBER(400318),
    NETWORK_NOTIFICATION_IS_OFF(400319),
    VISITOR_PERMISSION_DENIED(403999), BOT_PERMISSION_DENIED(403998),
    // Client SDK Errors
    INVALID_PARAMETER(800110), MALFORMED_DATA(800130), FILE_SIZE_EXCEEDED(800140),UNSUPPORTED(800800),
    CONNECTION_ERROR(800210), UNKNOWN_USER(810000), MISSING_API_KEY(810100),
    NOT_LOGGED_IN(800401), ESTABLISHING_ERROR(800402), TOKEN_EXPIRED(800403),
    HANDLER_NOT_SET(800404), TOKEN_RENEWAL_FAILED(800405),
    UNKNOWN(800000);

    fun `is`(error: AmityError?): Boolean {
        return equals(error)
    }

    companion object {
        private val TAG = AmityError::class.java.name
        @JvmStatic
        fun from(t: Throwable?): AmityError {
            return if (t is AmityException) {
                val errorCode = t.code
                for (error in values()) {
                    if (error.code == errorCode) {
                        return error
                    }
                }
                AmityLog.tag(TAG).e("Unknown error code from server: %s", errorCode)
                UNKNOWN
            } else {
                UNKNOWN
            }
        }


        fun from(code: Int): AmityError {
            return AmityError.values().find {
                it.code == code
            } ?: UNKNOWN
        }
    }
}