package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.comment.CommentEventPersister
import com.amity.socialcloud.sdk.social.data.post.engine.DeleteTask
import com.amity.socialcloud.sdk.social.data.post.engine.PostCommentCountEngine
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import io.reactivex.rxjava3.schedulers.Schedulers

internal class CommentDeleted : CommentEventListener() {

    override fun getEventName(): String {
        return "comment.deleted"
    }

    override fun processEvent(dto: EkoCommentAndUserListDto) {
        CommentEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnComplete {
                // Queue DeleteTask for local comment count tracking (all levels, not just top-level)
                dto.comments?.forEach { comment ->
                    if (comment.referenceType == "post") {
                        PostCommentCountEngine.queueCommentChangeTask(
                            DeleteTask(
                                postId = comment.referenceId,
                                commentId = comment.commentId
                            )
                        )
                    }
                }
            }
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

}