package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.data.comment.CommentEventPersister
import com.amity.socialcloud.sdk.social.data.post.engine.CreateTask
import com.amity.socialcloud.sdk.social.data.post.engine.PostCommentCountEngine
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal class CommentCreated : CommentEventListener() {

    override fun getEventName(): String {
        return "comment.created"
    }

    override fun shouldProcessEvent(dto: EkoCommentAndUserListDto): Boolean {
        return true
    }

    override fun processEvent(dto: EkoCommentAndUserListDto) {
        CommentEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnComplete {
                // Queue CreateTask for local comment count tracking (all levels, not just top-level)
                dto.comments?.forEach { comment ->
                    if (comment.referenceType == "post") {
                        PostCommentCountEngine.queueCommentChangeTask(
                            CreateTask(
                                postId = comment.referenceId,
                                commentId = comment.commentId,
                                createdAt = comment.getCreatedAt() ?: DateTime.now()
                            )
                        )
                    }
                }
            }
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()
    }

}