package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.dto.video.RoomListDto
import com.amity.socialcloud.sdk.dto.video.RoomRecordedUrlsDto
import com.amity.socialcloud.sdk.dto.video.EkoRoomBroadcastDataDto
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.socket.request.CreateRoomRequest
import com.ekoapp.ekosdk.internal.api.socket.request.RemoveRoomParticipantRequest
import com.ekoapp.ekosdk.internal.api.socket.request.UpdateRoomRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class RoomRemoteDataStore {

    fun createRoom(request: CreateRoomRequest): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.createRoom(request)
        }
    }

    fun queryRooms(
        statuses: List<String>?,
        types: List<String>?,
        isDeleted: Boolean?,
        sortBy: String?,
        limit: Int? = null,
        token: String? = null,
    ): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.queryRooms(
                statuses = statuses,
                types = types,
                isDeleted = isDeleted,
                sortBy = sortBy,
                limit = limit,
                token = token
            )
        }
    }

    fun getRoom(roomId: String): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.getRoom(roomId)
        }
    }

    fun updateRoom(roomId: String, request: UpdateRoomRequest): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.updateRoom(roomId, request)
        }
    }

    fun deleteRoom(roomId: String): Single<JsonObject> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.deleteRoom(roomId)
        }
    }

    fun leaveRoom(roomId: String): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.leaveRoom(roomId)
        }
    }

    fun removeParticipant(roomId: String, userId: String): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.removeParticipant(
                roomId = roomId,
                userId = userId,
            )
        }
    }

    fun stopRoom(roomId: String): Single<RoomListDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.stopRoom(roomId)
        }
    }

    fun getRoomRecordedUrls(roomId: String): Single<RoomRecordedUrlsDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.getRoomRecordedUrls(roomId)
        }
    }

    fun getBroadcasterData(roomId: String): Single<EkoRoomBroadcastDataDto> {
        return AmityHttpClient.get(RoomApi::class).flatMap { api ->
            api.getBroadcasterData(roomId)
        }
    }
}
