/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.UserMarkerEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class UserMarkerDao_Impl
extends UserMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<UserMarkerEntity> __insertAdapterOfUserMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<UserMarkerEntity> __deleteAdapterOfUserMarkerEntity;
    private final EntityDeleteOrUpdateAdapter<UserMarkerEntity> __updateAdapterOfUserMarkerEntity;

    public UserMarkerDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfUserMarkerEntity = new EntityInsertAdapter<UserMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_marker` (`userId`,`unreadCount`,`lastSyncAt`,`hasMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserMarkerEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                String _tmp = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastSyncAt());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                int _tmp_1 = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(4, (long)_tmp_1);
                String _tmp_2 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfUserMarkerEntity = new EntityDeleteOrUpdateAdapter<UserMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_marker` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserMarkerEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserMarkerEntity = new EntityDeleteOrUpdateAdapter<UserMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_marker` SET `userId` = ?,`unreadCount` = ?,`lastSyncAt` = ?,`hasMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserMarkerEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                statement.bindLong(2, (long)entity.getUnreadCount());
                String _tmp = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastSyncAt());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                int _tmp_1 = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(4, (long)_tmp_1);
                String _tmp_2 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = UserMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(UserMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserMarkerEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends UserMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserMarkerEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(UserMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends UserMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserMarkerEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(UserMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfUserMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(UserMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserMarkerDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends UserMarkerEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserMarkerDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(UserMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserMarkerDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<UserMarkerEntity> get() {
        String _sql = "SELECT * from user_marker LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_marker"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_marker LIMIT 1");){
                UserMarkerEntity _result;
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfLastSyncAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSyncAt");
                int _columnIndexOfHasMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new UserMarkerEntity();
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    String _tmp = _stmt.isNull(_columnIndexOfLastSyncAt) ? null : _stmt.getText(_columnIndexOfLastSyncAt);
                    DateTime _tmpLastSyncAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setLastSyncAt(_tmpLastSyncAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfHasMentioned);
                    boolean _tmpHasMentioned = _tmp_1 != 0;
                    _result.setHasMentioned(_tmpHasMentioned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserMarkerEntity userMarkerEntity = _result;
                return userMarkerEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_marker";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_marker");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String userId) {
        String _sql = "DELETE from user_marker where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_marker where userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

