/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoChannelMembershipDao_Impl
extends EkoChannelMembershipDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChannelMembershipEntity> __insertAdapterOfChannelMembershipEntity;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChannelMembershipEntity> __deleteAdapterOfChannelMembershipEntity;
    private final EntityDeleteOrUpdateAdapter<ChannelMembershipEntity> __updateAdapterOfChannelMembershipEntity;

    public EkoChannelMembershipDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChannelMembershipEntity = new EntityInsertAdapter<ChannelMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel_membership` (`id`,`channelId`,`userId`,`readToSegment`,`lastMentionedSegment`,`membership`,`isMuted`,`isBanned`,`roles`,`permissions`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMembershipEntity entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                statement.bindLong(4, (long)entity.getReadToSegment());
                statement.bindLong(5, (long)entity.getLastMentionedSegment());
                if (entity.getMembership() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getMembership());
                }
                int _tmp = entity.isMuted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                int _tmp_1 = entity.isBanned() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                String _tmp_2 = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                String _tmp_5 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_5);
                }
                String _tmp_6 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_6);
                }
            }
        };
        this.__deleteAdapterOfChannelMembershipEntity = new EntityDeleteOrUpdateAdapter<ChannelMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel_membership` WHERE `channelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMembershipEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfChannelMembershipEntity = new EntityDeleteOrUpdateAdapter<ChannelMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel_membership` SET `id` = ?,`channelId` = ?,`userId` = ?,`readToSegment` = ?,`lastMentionedSegment` = ?,`membership` = ?,`isMuted` = ?,`isBanned` = ?,`roles` = ?,`permissions` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChannelMembershipEntity entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                statement.bindLong(4, (long)entity.getReadToSegment());
                statement.bindLong(5, (long)entity.getLastMentionedSegment());
                if (entity.getMembership() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getMembership());
                }
                int _tmp = entity.isMuted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                int _tmp_1 = entity.isBanned() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                String _tmp_2 = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                String _tmp_5 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_5);
                }
                String _tmp_6 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_6);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChannelMembershipEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelMembershipEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChannelMembershipEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChannelMembershipEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChannelMembershipEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelMembershipEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChannelMembershipEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChannelMembershipEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChannelMembershipEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChannelMembershipEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChannelMembershipEntity membership) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelMembershipDao_Impl.super.insert(membership);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChannelMembershipEntity> memberships) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelMembershipDao_Impl.super.insert(memberships);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateUser(String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelMembershipDao_Impl.super.updateUser(userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public ChannelMembershipEntity getByIdNow(String id) {
        String _sql = "SELECT * from channel_membership where id = ? LIMIT 1";
        return (ChannelMembershipEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_membership where id = ? LIMIT 1");){
                ChannelMembershipEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _result.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMembershipEntity channelMembershipEntity = _result;
                return channelMembershipEntity;
            }
        });
    }

    @Override
    public List<ChannelMembershipEntity> getByIdsNow(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from channel_membership where id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT 1");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<ChannelMembershipEntity> _result = new ArrayList<ChannelMembershipEntity>();
                while (_stmt.step()) {
                    ChannelMembershipEntity _item_1 = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _item_1.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _item_1.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _item_1.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _item_1.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _item_1.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _item_1.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _item_1.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _item_1.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<ChannelMembershipEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<ChannelMembershipEntity> getByChannelIdAndUserIdImpl(String channelId, String userId) {
        String _sql = "SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_membership"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1");){
                ChannelMembershipEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _result.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMembershipEntity channelMembershipEntity = _result;
                return channelMembershipEntity;
            }
        });
    }

    @Override
    Flowable<List<ChannelMembershipEntity>> getByChannelIdImpl(String channelId) {
        String _sql = "SELECT * from channel_membership where channelId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_membership"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_membership where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<ChannelMembershipEntity> _result = new ArrayList<ChannelMembershipEntity>();
                while (_stmt.step()) {
                    ChannelMembershipEntity _item = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _item.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _item.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _item.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _item.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _item.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _item.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _item.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _item.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<ChannelMembershipEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public ChannelMembershipEntity getByChannelIdAndUserIdNow(String channelId, String userId) {
        String _sql = "SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1";
        return (ChannelMembershipEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1");){
                ChannelMembershipEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _result.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMembershipEntity channelMembershipEntity = _result;
                return channelMembershipEntity;
            }
        });
    }

    @Override
    public List<ChannelMembershipEntity> getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from channel_membership where channelId = ?";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from channel_membership where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<ChannelMembershipEntity> _result = new ArrayList<ChannelMembershipEntity>();
                while (_stmt.step()) {
                    ChannelMembershipEntity _item = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _item.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _item.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _item.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _item.setMembership(_tmpMembership);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp != 0;
                    _item.setMuted(_tmpIsMuted);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_1 != 0;
                    _item.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _item.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _item.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<ChannelMembershipEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<ChannelMembershipEntity> getLatestChannelMembershipImpl(String channelId, String[] memberships, Boolean isFilterMuted, Boolean isMuted, Boolean isFilterByRoles, String[] roles, int hash, int nonce, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from channel_membership where channel_membership.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel_membership.membership in (");
        int _inputSize = memberships == null ? 1 : memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel_membership.isMuted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else isMuted is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel_membership.userId in (SELECT userId from channel_role where channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and roleName in (");
        int _inputSize_1 = roles == null ? 1 : roles.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else userId is not null end and channel_membership.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel_membership.userId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by channel_membership.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_membership", "channel_role", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                ChannelMembershipEntity _result;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                if (memberships == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String string : memberships) {
                        if (string == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, string);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 2 + _inputSize;
                Integer n = isFilterMuted == null ? null : (_tmp = Integer.valueOf(isFilterMuted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3 + _inputSize;
                Integer n2 = isMuted == null ? null : (_tmp_1 = Integer.valueOf(isMuted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 4 + _inputSize;
                Integer n3 = isFilterByRoles == null ? null : (_tmp_2 = Integer.valueOf(isFilterByRoles != false ? 1 : 0));
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_2.intValue());
                }
                _argIndex = 5 + _inputSize;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 6 + _inputSize;
                if (roles == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item_1 : roles) {
                        if (_item_1 == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item_1);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 6 + _inputSize + _inputSize_1;
                String string = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (string == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, string);
                }
                _argIndex = 7 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 8 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionedSegment");
                int _columnIndexOfMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChannelMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                    _result.setLastMentionedSegment(_tmpLastMentionedSegment);
                    String _tmpMembership = _stmt.isNull(_columnIndexOfMembership) ? null : _stmt.getText(_columnIndexOfMembership);
                    _result.setMembership(_tmpMembership);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_4 != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsBanned);
                    boolean _tmpIsBanned = _tmp_5 != 0;
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_6);
                    _result.setRoles(_tmpRoles);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_7);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChannelMembershipEntity channelMembershipEntity = _result;
                return channelMembershipEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel_membership";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_membership");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateMembership(String channelId, String userId, String membership) {
        String _sql = "UPDATE channel_membership set membership = ?, isBanned = 1 where channelId = ? and userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_membership set membership = ?, isBanned = 1 where channelId = ? and userId = ?");){
                int _argIndex = 1;
                if (membership == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, membership);
                }
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void updateReadToSegment(String channelId, String userId, int readToSegment) {
        String _sql = "UPDATE channel_membership set readToSegment = ? where channelId = ? and userId = ? and readToSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_membership set readToSegment = ? where channelId = ? and userId = ? and readToSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)readToSegment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)readToSegment);
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void updateLastMentionedSegment(String channelId, String userId, int lastMentionedSegment) {
        String _sql = "UPDATE channel_membership set lastMentionedSegment = ? where channelId = ? and userId = ? and lastMentionedSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_membership set lastMentionedSegment = ? where channelId = ? and userId = ? and lastMentionedSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)lastMentionedSegment);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)lastMentionedSegment);
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void updateMemberIsMuted(String channelId, String userId, boolean isMuted) {
        String _sql = "UPDATE channel_membership set isMuted = ? where channelId = ? and userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_membership set isMuted = ? where channelId = ? and userId = ?");){
                int _argIndex = 1;
                int _tmp = isMuted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    public void deleteAllFromChannel(String channelId) {
        String _sql = "DELETE from channel_membership where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel_membership where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    void updateUserImpl(String userId) {
        String _sql = "UPDATE channel_membership set userId = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel_membership set userId = ? where userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

