/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.watch;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity;
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionDao;
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionSyncState;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class WatchSessionDao_Impl
extends WatchSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<WatchSessionEntity> __insertAdapterOfWatchSessionEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<WatchSessionEntity> __deleteAdapterOfWatchSessionEntity;
    private final EntityDeleteOrUpdateAdapter<WatchSessionEntity> __updateAdapterOfWatchSessionEntity;

    public WatchSessionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfWatchSessionEntity = new EntityInsertAdapter<WatchSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `watch_session` (`sessionId`,`roomId`,`watchSeconds`,`startTime`,`endTime`,`syncState`,`syncedAt`,`retryCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull WatchSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
                if (entity.getRoomId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getRoomId());
                }
                statement.bindLong(3, entity.getWatchSeconds());
                String _tmp = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSyncState());
                }
                String _tmp_2 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSyncedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                statement.bindLong(8, (long)entity.getRetryCount());
                String _tmp_3 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
                String _tmp_5 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_5);
                }
            }
        };
        this.__deleteAdapterOfWatchSessionEntity = new EntityDeleteOrUpdateAdapter<WatchSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `watch_session` WHERE `sessionId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull WatchSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
            }
        };
        this.__updateAdapterOfWatchSessionEntity = new EntityDeleteOrUpdateAdapter<WatchSessionEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `watch_session` SET `sessionId` = ?,`roomId` = ?,`watchSeconds` = ?,`startTime` = ?,`endTime` = ?,`syncState` = ?,`syncedAt` = ?,`retryCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `sessionId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull WatchSessionEntity entity) {
                if (entity.getSessionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSessionId());
                }
                if (entity.getRoomId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getRoomId());
                }
                statement.bindLong(3, entity.getWatchSeconds());
                String _tmp = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSyncState());
                }
                String _tmp_2 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSyncedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                statement.bindLong(8, (long)entity.getRetryCount());
                String _tmp_3 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
                String _tmp_5 = WatchSessionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_5);
                }
                if (entity.getSessionId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getSessionId());
                }
            }
        };
    }

    @Override
    public void insertImpl(WatchSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfWatchSessionEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends WatchSessionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfWatchSessionEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(WatchSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfWatchSessionEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends WatchSessionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfWatchSessionEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(WatchSessionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfWatchSessionEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(WatchSessionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            WatchSessionDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends WatchSessionEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            WatchSessionDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(WatchSessionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            WatchSessionDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateSyncState(WatchSessionSyncState fromState, WatchSessionSyncState toState) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            WatchSessionDao_Impl.super.updateSyncState(fromState, toState);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<List<WatchSessionEntity>> getAllImpl(String[] syncStates) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from watch_session where syncState in (");
        int _inputSize = syncStates.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND watchSeconds > 0 order by startTime DESC");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"watch_session"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : syncStates) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfSessionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sessionId");
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfWatchSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watchSeconds");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSyncedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncedAt");
                int _columnIndexOfRetryCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retryCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<WatchSessionEntity> _result = new ArrayList<WatchSessionEntity>();
                while (_stmt.step()) {
                    WatchSessionEntity _item_1 = new WatchSessionEntity();
                    String _tmpSessionId = _stmt.isNull(_columnIndexOfSessionId) ? null : _stmt.getText(_columnIndexOfSessionId);
                    _item_1.setSessionId(_tmpSessionId);
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _item_1.setRoomId(_tmpRoomId);
                    long _tmpWatchSeconds = _stmt.getLong(_columnIndexOfWatchSeconds);
                    _item_1.setWatchSeconds(_tmpWatchSeconds);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setEndTime(_tmpEndTime);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item_1.setSyncState(_tmpSyncState);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfSyncedAt) ? null : _stmt.getText(_columnIndexOfSyncedAt);
                    DateTime _tmpSyncedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setSyncedAt(_tmpSyncedAt);
                    int _tmpRetryCount = (int)_stmt.getLong(_columnIndexOfRetryCount);
                    _item_1.setRetryCount(_tmpRetryCount);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<WatchSessionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<WatchSessionEntity> getByIdImpl(String sessionId) {
        String _sql = "SELECT * from watch_session where sessionId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"watch_session"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from watch_session where sessionId = ?");){
                WatchSessionEntity _result;
                int _argIndex = 1;
                if (sessionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sessionId);
                }
                int _columnIndexOfSessionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sessionId");
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfWatchSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watchSeconds");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfSyncedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncedAt");
                int _columnIndexOfRetryCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"retryCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new WatchSessionEntity();
                    String _tmpSessionId = _stmt.isNull(_columnIndexOfSessionId) ? null : _stmt.getText(_columnIndexOfSessionId);
                    _result.setSessionId(_tmpSessionId);
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _result.setRoomId(_tmpRoomId);
                    long _tmpWatchSeconds = _stmt.getLong(_columnIndexOfWatchSeconds);
                    _result.setWatchSeconds(_tmpWatchSeconds);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setEndTime(_tmpEndTime);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfSyncedAt) ? null : _stmt.getText(_columnIndexOfSyncedAt);
                    DateTime _tmpSyncedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setSyncedAt(_tmpSyncedAt);
                    int _tmpRetryCount = (int)_stmt.getLong(_columnIndexOfRetryCount);
                    _result.setRetryCount(_tmpRetryCount);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                WatchSessionEntity watchSessionEntity = _result;
                return watchSessionEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from watch_session";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from watch_session");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateSyncStateImpl(String fromState, String toState) {
        String _sql = "UPDATE watch_session set syncState = ? where syncState = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE watch_session set syncState = ? where syncState = ?");){
                int _argIndex = 1;
                if (toState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, toState);
                }
                _argIndex = 2;
                if (fromState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, fromState);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

