/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.post;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.post.query.AmityCommunityFeedSortOption;
import com.amity.socialcloud.sdk.api.social.post.query.AmityUserFeedSortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.tombstone.TombstoneRepository;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.link.AmityLink;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.model.social.post.AmityPost;
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment;
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore;
import com.amity.socialcloud.sdk.social.data.post.PostModelMapper;
import com.amity.socialcloud.sdk.social.data.post.PostQueryPersister;
import com.amity.socialcloud.sdk.social.data.post.PostRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.post.PostRepository;
import com.amity.socialcloud.sdk.social.data.post.live.LiveRoomPostSinglePageMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.CommunityPostMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.CustomPostRankingMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.GlobalFeedMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.SearchPostMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.SemanticSearchPostMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.UserFeedMediator;
import com.amity.socialcloud.sdk.social.data.post.paging.UserPostMediator;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.TombstoneModelType;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.paging.SinglePagePagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012JL\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJG\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0002\u0010$JW\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0002\u0010*J6\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001cJ(\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001cJ(\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001cJ(\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u00102\u0006\u0010\u0017\u001a\u00020\u000b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J]\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00150\u00102\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u000bJ\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J~\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b082\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010\u00122\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u001a2\b\u0010>\u001a\u0004\u0018\u00010:2\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010\u00122\u0010\b\u0002\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00122\u0010\b\u0002\u0010A\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010\u0012J\u0016\u0010C\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u001cJ\u000e\u0010E\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000bJ\u000e\u0010F\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000bJb\u0010G\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000b2\u0006\u00109\u001a\u00020:2\b\u0010>\u001a\u0004\u0018\u00010:2\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010\u00122\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010\u00122\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00122\u0010\b\u0002\u0010A\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010\u0012J\u0016\u0010H\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000bJ]\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0007\u00a2\u0006\u0002\u0010PJ\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020:082\u0006\u00105\u001a\u00020\u000b\u00a8\u0006R"}, d2={"Lcom/amity/socialcloud/sdk/social/data/post/PostRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/PostEntity;", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost;", "<init>", "()V", "getDefaultPageSize", "", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getPostByIds", "", "postIds", "semanticSearchPosts", "Landroidx/paging/PagingData;", "query", "targetType", "targetId", "postTypes", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPost$DataType;", "matchingOnlyParentPosts", "", "includeMixedStructure", "getUserPostPagingData", "userId", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;", "isDeleted", "dataTypes", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;Ljava/lang/Boolean;Ljava/util/List;Z)Lio/reactivex/rxjava3/core/Flowable;", "getCommunityPostPagingData", "communityId", "Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityCommunityFeedSortOption;Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;Ljava/lang/Boolean;Ljava/util/List;ZZ)Lio/reactivex/rxjava3/core/Flowable;", "searchPosts", "hashtags", "getGlobalFeedPagingData", "getCustomPostRankingPagingData", "getLiveRoomPosts", "targetIds", "getUserFeed", "feedSources", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/post/query/AmityUserFeedSortOption;Ljava/lang/Boolean;Ljava/util/List;ZLjava/util/List;Z)Lio/reactivex/rxjava3/core/Flowable;", "getPost", "postId", "getPosts", "createPostV4", "Lio/reactivex/rxjava3/core/Single;", "data", "Lcom/google/gson/JsonObject;", "attachments", "Lcom/amity/socialcloud/sdk/model/social/post/AmityPostAttachment;", "dataType", "metadata", "mentionees", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "links", "Lcom/amity/socialcloud/sdk/model/core/link/AmityLink;", "deletePost", "hardDelete", "approvePost", "declinePost", "editPost", "flagPost", "reason", "Lcom/ekoapp/ekosdk/internal/api/socket/request/FlagContentRequest;", "unFlagPost", "getLatestPost", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;ZLcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "isFlaggedByMe", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nPostRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostRepository.kt\ncom/amity/socialcloud/sdk/social/data/post/PostRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,499:1\n1563#2:500\n1634#2,3:501\n1563#2:504\n1634#2,3:505\n*S KotlinDebug\n*F\n+ 1 PostRepository.kt\ncom/amity/socialcloud/sdk/social/data/post/PostRepository\n*L\n348#1:500\n348#1:501,3\n484#1:504\n484#1:505,3\n*E\n"})
public final class PostRepository
extends AmityObjectRepository<PostEntity, AmityPost> {
    private final int getDefaultPageSize() {
        return 20;
    }

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new PostRemoteDataStore().fetchPost(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE).onErrorResumeNext(new Function(objectId){
            final /* synthetic */ String $objectId;
            {
                this.$objectId = $objectId;
            }

            public final CompletableSource apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND ? (CompletableSource)new PostLocalDataStore().hardDelete(this.$objectId).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    @Override
    @Nullable
    public PostEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new PostLocalDataStore().getPost(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<PostEntity, AmityPost> mapper() {
        return new PostModelMapper();
    }

    @Override
    @NotNull
    public Flowable<PostEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new PostLocalDataStore().observe(objectId);
    }

    @NotNull
    public final Flowable<List<AmityPost>> getPostByIds(@NotNull List<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Flowable flowable = new PostRemoteDataStore().getPostByIds(postIds).flatMap((Function)getPostByIds.1.INSTANCE).flatMapPublisher((Function)getPostByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> semanticSearchPosts(@NotNull String query, @Nullable String targetType, @Nullable String targetId, @NotNull List<? extends AmityPost.DataType> postTypes, boolean matchingOnlyParentPosts, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new SemanticSearchPostMediator(query, targetType, targetId, postTypes, matchingOnlyParentPosts, includeMixedStructure), () -> PostRepository.semanticSearchPosts$lambda$0(query, targetId, targetType, matchingOnlyParentPosts, postTypes, includeMixedStructure), (ModelMapper)new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> getUserPostPagingData(@NotNull String userId, @NotNull AmityUserFeedSortOption sortOption, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new UserPostMediator(userId, sortOption.getApiKey(), isDeleted, dataTypes, includeMixedStructure), () -> PostRepository.getUserPostPagingData$lambda$1(userId, sortOption, isDeleted, dataTypes, includeMixedStructure), (ModelMapper)new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> getCommunityPostPagingData(@NotNull String communityId, @NotNull AmityCommunityFeedSortOption sortOption, @NotNull AmityFeedType feedType, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> dataTypes, boolean matchingOnlyParentPosts, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new CommunityPostMediator(communityId, sortOption.getApiKey(), isDeleted, feedType, dataTypes, matchingOnlyParentPosts, includeMixedStructure), () -> PostRepository.getCommunityPostPagingData$lambda$2(communityId, sortOption, feedType, isDeleted, dataTypes, matchingOnlyParentPosts, includeMixedStructure), (ModelMapper)new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> searchPosts(@NotNull List<String> hashtags, @NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(hashtags, (String)"hashtags");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new SearchPostMediator(null, null, hashtags, null, dataTypes, includeMixedStructure), () -> PostRepository.searchPosts$lambda$3(hashtags, dataTypes, includeMixedStructure), new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> getGlobalFeedPagingData(@NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new GlobalFeedMediator(dataTypes, includeMixedStructure), () -> PostRepository.getGlobalFeedPagingData$lambda$4(dataTypes, includeMixedStructure), new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> getCustomPostRankingPagingData(@NotNull List<? extends AmityPost.DataType> dataTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new CustomPostRankingMediator(dataTypes, includeMixedStructure), () -> PostRepository.getCustomPostRankingPagingData$lambda$5(dataTypes, includeMixedStructure), new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<List<AmityPost>> getLiveRoomPosts(@NotNull String targetType, @NotNull List<String> targetIds) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(targetIds, (String)"targetIds");
        List normalizedTargetIds = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)targetIds));
        SinglePagePagerCreator pagerCreator = new SinglePagePagerCreator(new LiveRoomPostSinglePageMediator(targetType, normalizedTargetIds), new PostLocalDataStore().getLiveRoomPosts(targetType, normalizedTargetIds), new PostModelMapper());
        return pagerCreator.create();
    }

    @NotNull
    public final Flowable<PagingData<AmityPost>> getUserFeed(@NotNull String userId, @NotNull AmityUserFeedSortOption sortOption, @Nullable Boolean isDeleted, @NotNull List<String> feedSources, boolean matchingOnlyParentPosts, @NotNull List<? extends AmityPost.DataType> postTypes, boolean includeMixedStructure) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(feedSources, (String)"feedSources");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        int n = this.getDefaultPageSize();
        int n2 = this.getDefaultPageSize() / 2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(n, 0, true, n2, 0, 0, 48, null), null, new UserFeedMediator(userId, sortOption.getApiKey(), isDeleted, postTypes, matchingOnlyParentPosts, feedSources, includeMixedStructure), () -> PostRepository.getUserFeed$lambda$6(userId, sortOption, isDeleted, feedSources, matchingOnlyParentPosts, postTypes, includeMixedStructure), (ModelMapper)new PostModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @Nullable
    public final AmityPost getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        PostEntity post = new PostLocalDataStore().getPost(postId);
        return post == null ? null : new PostModelMapper().map(post);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AmityPost> getPosts(@NotNull List<String> postIds) {
        List list;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        if (!((Collection)postIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = new PostLocalDataStore().getPosts(postIds);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PostEntity postEntity = (PostEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PostModelMapper().map((PostEntity)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List posts = list;
        return posts;
    }

    @NotNull
    public final Single<String> createPostV4(@NotNull String targetType, @NotNull String targetId, @NotNull JsonObject data, @Nullable List<AmityPostAttachment> attachments, @Nullable AmityPost.DataType dataType, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees, @Nullable List<String> hashtags, @Nullable List<AmityLink> links) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Single single = new PostRemoteDataStore().createPost(targetType, targetId, data, attachments, dataType, metadata, mentionees, hashtags, links).flatMap((Function)createPostV4.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    public static /* synthetic */ Single createPostV4$default(PostRepository postRepository, String string, String string2, JsonObject jsonObject, List list, AmityPost.DataType dataType, JsonObject jsonObject2, List list2, List list3, List list4, int n, Object object) {
        if ((n & 0x10) != 0) {
            dataType = null;
        }
        if ((n & 0x80) != 0) {
            list3 = null;
        }
        if ((n & 0x100) != 0) {
            list4 = null;
        }
        return postRepository.createPostV4(string, string2, jsonObject, list, dataType, jsonObject2, list2, list3, list4);
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Completable completable = new PostRemoteDataStore().deletePost(postId, hardDelete).flatMapCompletable(new Function(hardDelete, postId){
            final /* synthetic */ boolean $hardDelete;
            final /* synthetic */ String $postId;
            {
                this.$hardDelete = $hardDelete;
                this.$postId = $postId;
            }

            public final CompletableSource apply(EkoDeletionDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !it.isSuccess() ? (CompletableSource)Completable.complete() : (this.$hardDelete ? (CompletableSource)new PostLocalDataStore().hardDelete(this.$postId).andThen((CompletableSource)Completable.defer(() -> deletePost.1.apply$lambda$0(this.$postId))) : (CompletableSource)new PostLocalDataStore().softDelete(this.$postId));
            }

            private static final CompletableSource apply$lambda$0(String $postId) {
                return (CompletableSource)new TombstoneRepository().saveTombstone($postId, TombstoneModelType.POST, AmityError.ITEM_NOT_FOUND);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable approvePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Ref.ObjectRef initialFeedType = new Ref.ObjectRef();
        initialFeedType.element = AmityFeedType.NONE;
        Completable completable = Flowable.fromCallable(() -> PostRepository.approvePost$lambda$8(initialFeedType, postId)).flatMapCompletable(new Function(postId){
            final /* synthetic */ String $postId;
            {
                this.$postId = $postId;
            }

            public final CompletableSource apply(Unit it) {
                return (CompletableSource)new PostRemoteDataStore().approvePost(this.$postId).ignoreElement();
            }
        }).doOnError(new Consumer(postId, (Ref.ObjectRef<AmityFeedType>)initialFeedType){
            final /* synthetic */ String $postId;
            final /* synthetic */ Ref.ObjectRef<AmityFeedType> $initialFeedType;
            {
                this.$postId = $postId;
                this.$initialFeedType = $initialFeedType;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.FORBIDDEN_ERROR) {
                    new PostLocalDataStore().updateFeedType(this.$postId, AmityFeedType.NONE);
                } else {
                    new PostLocalDataStore().updateFeedType(this.$postId, (AmityFeedType)((Object)this.$initialFeedType.element));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnError(...)");
        return completable;
    }

    @NotNull
    public final Completable declinePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Ref.ObjectRef initialFeedType = new Ref.ObjectRef();
        initialFeedType.element = AmityFeedType.NONE;
        Completable completable = Flowable.fromCallable(() -> PostRepository.declinePost$lambda$9(initialFeedType, postId)).flatMapCompletable(new Function(postId){
            final /* synthetic */ String $postId;
            {
                this.$postId = $postId;
            }

            public final CompletableSource apply(Unit it) {
                return (CompletableSource)new PostRemoteDataStore().declinePost(this.$postId).ignoreElement();
            }
        }).doOnError(new Consumer(postId, (Ref.ObjectRef<AmityFeedType>)initialFeedType){
            final /* synthetic */ String $postId;
            final /* synthetic */ Ref.ObjectRef<AmityFeedType> $initialFeedType;
            {
                this.$postId = $postId;
                this.$initialFeedType = $initialFeedType;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.FORBIDDEN_ERROR) {
                    new PostLocalDataStore().updateFeedType(this.$postId, AmityFeedType.NONE);
                } else {
                    new PostLocalDataStore().updateFeedType(this.$postId, (AmityFeedType)((Object)this.$initialFeedType.element));
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnError(...)");
        return completable;
    }

    @NotNull
    public final Completable editPost(@NotNull String postId, @NotNull JsonObject data, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees, @Nullable List<AmityPostAttachment> attachments, @Nullable List<String> hashtags, @Nullable List<AmityLink> links) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Completable completable = new PostRemoteDataStore().editPost(postId, data, metadata, mentionees, attachments, hashtags, links).flatMapCompletable(new Function(postId){
            final /* synthetic */ String $postId;
            {
                this.$postId = $postId;
            }

            /*
             * WARNING - void declaration
             */
            public final CompletableSource apply(EkoPostQueryDto it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$map$iv = it.getChildren();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void child;
                    EkoPostDto ekoPostDto = (EkoPostDto)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(child.getPostId());
                }
                List childIds = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                childIds.add(this.$postId);
                return (CompletableSource)new PostQueryPersister().persist(it).andThen((CompletableSource)new PostLocalDataStore().invalidateChildPosts(this.$postId, childIds));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    public static /* synthetic */ Completable editPost$default(PostRepository postRepository, String string, JsonObject jsonObject, JsonObject jsonObject2, List list, List list2, List list3, List list4, int n, Object object) {
        if ((n & 0x40) != 0) {
            list4 = null;
        }
        return postRepository.editPost(string, jsonObject, jsonObject2, list, list2, list3, list4);
    }

    @NotNull
    public final Completable flagPost(@NotNull String postId, @NotNull FlagContentRequest reason) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Completable completable = new PostRemoteDataStore().flagPost(postId, reason).flatMapCompletable((Function)flagPost.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable unFlagPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Completable completable = new PostRemoteDataStore().unFlagPost(postId).flatMapCompletable((Function)unFlagPost.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flowable<AmityPost> getLatestPost(@NotNull String targetId, @NotNull String targetType, @Nullable Boolean isDeleted, @NotNull List<? extends AmityPost.DataType> dataTypes, @Nullable AmityFeedType feedType, boolean includeMixedStructure, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        PostLocalDataStore postLocalDataStore = new PostLocalDataStore();
        Iterable $this$map$iv = dataTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityPost.DataType dataType = (AmityPost.DataType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getApiKey());
        }
        List list = (List)destination$iv$iv;
        Flowable flowable = postLocalDataStore.getLatestPosts(targetId, targetType, dynamicQueryStreamKeyCreator, nonce, isDeleted, list, includeMixedStructure, feedType).map((Function)getLatestPost.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    public static /* synthetic */ Flowable getLatestPost$default(PostRepository postRepository, String string, String string2, Boolean bl, List list, AmityFeedType amityFeedType, boolean bl2, DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            amityFeedType = null;
        }
        return postRepository.getLatestPost(string, string2, bl, list, amityFeedType, bl2, dynamicQueryStreamKeyCreator, n);
    }

    @NotNull
    public final Single<JsonObject> isFlaggedByMe(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostRemoteDataStore().isFlaggedByMe(postId);
    }

    private static final PagingSource semanticSearchPosts$lambda$0(String $query, String $targetId, String $targetType, boolean $matchingOnlyParentPosts, List $postTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getSemanticSearchPostsPagingSource($query, $targetId, $targetType, $matchingOnlyParentPosts, $postTypes, $includeMixedStructure);
    }

    private static final PagingSource getUserPostPagingData$lambda$1(String $userId, AmityUserFeedSortOption $sortOption, Boolean $isDeleted, List $dataTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getUserPostsPagingSource($userId, $sortOption, $isDeleted, $dataTypes, $includeMixedStructure);
    }

    private static final PagingSource getCommunityPostPagingData$lambda$2(String $communityId, AmityCommunityFeedSortOption $sortOption, AmityFeedType $feedType, Boolean $isDeleted, List $dataTypes, boolean $matchingOnlyParentPosts, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getCommunityPostsPagingSource($communityId, $sortOption, $feedType, $isDeleted, $dataTypes, $matchingOnlyParentPosts, $includeMixedStructure);
    }

    private static final PagingSource searchPosts$lambda$3(List $hashtags, List $dataTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().searchPostsPagingSource($hashtags, $dataTypes, $includeMixedStructure);
    }

    private static final PagingSource getGlobalFeedPagingData$lambda$4(List $dataTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getGlobalPostsPagingSource($dataTypes, $includeMixedStructure);
    }

    private static final PagingSource getCustomPostRankingPagingData$lambda$5(List $dataTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getGlobalPostsV5PagingSource($dataTypes, $includeMixedStructure);
    }

    private static final PagingSource getUserFeed$lambda$6(String $userId, AmityUserFeedSortOption $sortOption, Boolean $isDeleted, List $feedSources, boolean $matchingOnlyParentPosts, List $postTypes, boolean $includeMixedStructure) {
        return new PostLocalDataStore().getUserFeedPagingSource($userId, $sortOption, $isDeleted, $feedSources, $matchingOnlyParentPosts, $postTypes, $includeMixedStructure);
    }

    private static final Unit approvePost$lambda$8(Ref.ObjectRef $initialFeedType, String $postId) {
        $initialFeedType.element = new PostLocalDataStore().getFeedType($postId);
        new PostLocalDataStore().updateFeedType($postId, AmityFeedType.PUBLISHED);
        return Unit.INSTANCE;
    }

    private static final Unit declinePost$lambda$9(Ref.ObjectRef $initialFeedType, String $postId) {
        $initialFeedType.element = new PostLocalDataStore().getFeedType($postId);
        new PostLocalDataStore().updateFeedType($postId, AmityFeedType.DECLINED);
        return Unit.INSTANCE;
    }
}

