/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class CommunityJoinRequestDao_Impl
extends CommunityJoinRequestDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<JoinRequestEntity> __insertAdapterOfJoinRequestEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<JoinRequestEntity> __deleteAdapterOfJoinRequestEntity;
    private final EntityDeleteOrUpdateAdapter<JoinRequestEntity> __updateAdapterOfJoinRequestEntity;

    public CommunityJoinRequestDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfJoinRequestEntity = new EntityInsertAdapter<JoinRequestEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `joinRequest` (`joinRequestId`,`type`,`networkId`,`targetId`,`targetType`,`userId`,`status`,`respondedAt`,`createdDate`,`updatedDate`,`requestorId`,`requestorInternalId`,`requestorPublicId`,`responderId`,`responderInternalId`,`responderPublicId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull JoinRequestEntity entity) {
                if (entity.getJoinRequestId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getJoinRequestId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getNetworkId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getNetworkId());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getTargetType());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                String _tmp = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRespondedAt());
                if (_tmp == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp);
                }
                String _tmp_1 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedDate());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedDate());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                if (entity.getRequestorId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getRequestorId());
                }
                if (entity.getRequestorInternalId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getRequestorInternalId());
                }
                if (entity.getRequestorPublicId() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getRequestorPublicId());
                }
                if (entity.getResponderId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getResponderId());
                }
                if (entity.getResponderInternalId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getResponderInternalId());
                }
                if (entity.getResponderPublicId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getResponderPublicId());
                }
                String _tmp_3 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_3);
                }
                String _tmp_4 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_4);
                }
                String _tmp_5 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_5);
                }
            }
        };
        this.__deleteAdapterOfJoinRequestEntity = new EntityDeleteOrUpdateAdapter<JoinRequestEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `joinRequest` WHERE `joinRequestId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull JoinRequestEntity entity) {
                if (entity.getJoinRequestId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getJoinRequestId());
                }
            }
        };
        this.__updateAdapterOfJoinRequestEntity = new EntityDeleteOrUpdateAdapter<JoinRequestEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `joinRequest` SET `joinRequestId` = ?,`type` = ?,`networkId` = ?,`targetId` = ?,`targetType` = ?,`userId` = ?,`status` = ?,`respondedAt` = ?,`createdDate` = ?,`updatedDate` = ?,`requestorId` = ?,`requestorInternalId` = ?,`requestorPublicId` = ?,`responderId` = ?,`responderInternalId` = ?,`responderPublicId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `joinRequestId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull JoinRequestEntity entity) {
                if (entity.getJoinRequestId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getJoinRequestId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getNetworkId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getNetworkId());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getTargetType());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                String _tmp = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRespondedAt());
                if (_tmp == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp);
                }
                String _tmp_1 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedDate());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedDate());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                if (entity.getRequestorId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getRequestorId());
                }
                if (entity.getRequestorInternalId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getRequestorInternalId());
                }
                if (entity.getRequestorPublicId() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getRequestorPublicId());
                }
                if (entity.getResponderId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getResponderId());
                }
                if (entity.getResponderInternalId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getResponderInternalId());
                }
                if (entity.getResponderPublicId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getResponderPublicId());
                }
                String _tmp_3 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_3);
                }
                String _tmp_4 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_4);
                }
                String _tmp_5 = CommunityJoinRequestDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_5);
                }
                if (entity.getJoinRequestId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getJoinRequestId());
                }
            }
        };
    }

    @Override
    public void insertImpl(JoinRequestEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfJoinRequestEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends JoinRequestEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfJoinRequestEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends JoinRequestEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfJoinRequestEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(JoinRequestEntity joinRequest2) {
        if (joinRequest2 == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfJoinRequestEntity.handle(_connection, (Object)joinRequest2);
            return null;
        });
    }

    @Override
    public void updateImpl(JoinRequestEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfJoinRequestEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(JoinRequestEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            CommunityJoinRequestDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends JoinRequestEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            CommunityJoinRequestDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(JoinRequestEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            CommunityJoinRequestDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public JoinRequestEntity getByIdNowImpl(String joinRequestId) {
        String _sql = "SELECT * from joinRequest where joinRequestId = ?";
        return (JoinRequestEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from joinRequest where joinRequestId = ?");){
                JoinRequestEntity _result;
                int _argIndex = 1;
                if (joinRequestId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, joinRequestId);
                }
                int _columnIndexOfJoinRequestId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"joinRequestId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdDate");
                int _columnIndexOfUpdatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedDate");
                int _columnIndexOfRequestorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorId");
                int _columnIndexOfRequestorInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorInternalId");
                int _columnIndexOfRequestorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorPublicId");
                int _columnIndexOfResponderId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderId");
                int _columnIndexOfResponderInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderInternalId");
                int _columnIndexOfResponderPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderPublicId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new JoinRequestEntity();
                    String _tmpJoinRequestId = _stmt.isNull(_columnIndexOfJoinRequestId) ? null : _stmt.getText(_columnIndexOfJoinRequestId);
                    _result.setJoinRequestId(_tmpJoinRequestId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _result.setNetworkId(_tmpNetworkId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedDate) ? null : _stmt.getText(_columnIndexOfCreatedDate);
                    DateTime _tmpCreatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedDate(_tmpCreatedDate);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedDate) ? null : _stmt.getText(_columnIndexOfUpdatedDate);
                    DateTime _tmpUpdatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedDate(_tmpUpdatedDate);
                    String _tmpRequestorId = _stmt.isNull(_columnIndexOfRequestorId) ? null : _stmt.getText(_columnIndexOfRequestorId);
                    _result.setRequestorId(_tmpRequestorId);
                    String _tmpRequestorInternalId = _stmt.isNull(_columnIndexOfRequestorInternalId) ? null : _stmt.getText(_columnIndexOfRequestorInternalId);
                    _result.setRequestorInternalId(_tmpRequestorInternalId);
                    String _tmpRequestorPublicId = _stmt.isNull(_columnIndexOfRequestorPublicId) ? null : _stmt.getText(_columnIndexOfRequestorPublicId);
                    _result.setRequestorPublicId(_tmpRequestorPublicId);
                    String _tmpResponderId = _stmt.isNull(_columnIndexOfResponderId) ? null : _stmt.getText(_columnIndexOfResponderId);
                    _result.setResponderId(_tmpResponderId);
                    String _tmpResponderInternalId = _stmt.isNull(_columnIndexOfResponderInternalId) ? null : _stmt.getText(_columnIndexOfResponderInternalId);
                    _result.setResponderInternalId(_tmpResponderInternalId);
                    String _tmpResponderPublicId = _stmt.isNull(_columnIndexOfResponderPublicId) ? null : _stmt.getText(_columnIndexOfResponderPublicId);
                    _result.setResponderPublicId(_tmpResponderPublicId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                JoinRequestEntity joinRequestEntity = _result;
                return joinRequestEntity;
            }
        });
    }

    @Override
    public Flowable<List<JoinRequestEntity>> observeByJoinRequestIdsImpl(List<String> joinRequestIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from joinRequest where joinRequest.joinRequestId in (");
        int _inputSize = joinRequestIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"joinRequest"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : joinRequestIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfJoinRequestId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"joinRequestId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdDate");
                int _columnIndexOfUpdatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedDate");
                int _columnIndexOfRequestorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorId");
                int _columnIndexOfRequestorInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorInternalId");
                int _columnIndexOfRequestorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorPublicId");
                int _columnIndexOfResponderId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderId");
                int _columnIndexOfResponderInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderInternalId");
                int _columnIndexOfResponderPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderPublicId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<JoinRequestEntity> _result = new ArrayList<JoinRequestEntity>();
                while (_stmt.step()) {
                    JoinRequestEntity _item_1 = new JoinRequestEntity();
                    String _tmpJoinRequestId = _stmt.isNull(_columnIndexOfJoinRequestId) ? null : _stmt.getText(_columnIndexOfJoinRequestId);
                    _item_1.setJoinRequestId(_tmpJoinRequestId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_1.setType(_tmpType);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _item_1.setNetworkId(_tmpNetworkId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item_1.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedDate) ? null : _stmt.getText(_columnIndexOfCreatedDate);
                    DateTime _tmpCreatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setCreatedDate(_tmpCreatedDate);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedDate) ? null : _stmt.getText(_columnIndexOfUpdatedDate);
                    DateTime _tmpUpdatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setUpdatedDate(_tmpUpdatedDate);
                    String _tmpRequestorId = _stmt.isNull(_columnIndexOfRequestorId) ? null : _stmt.getText(_columnIndexOfRequestorId);
                    _item_1.setRequestorId(_tmpRequestorId);
                    String _tmpRequestorInternalId = _stmt.isNull(_columnIndexOfRequestorInternalId) ? null : _stmt.getText(_columnIndexOfRequestorInternalId);
                    _item_1.setRequestorInternalId(_tmpRequestorInternalId);
                    String _tmpRequestorPublicId = _stmt.isNull(_columnIndexOfRequestorPublicId) ? null : _stmt.getText(_columnIndexOfRequestorPublicId);
                    _item_1.setRequestorPublicId(_tmpRequestorPublicId);
                    String _tmpResponderId = _stmt.isNull(_columnIndexOfResponderId) ? null : _stmt.getText(_columnIndexOfResponderId);
                    _item_1.setResponderId(_tmpResponderId);
                    String _tmpResponderInternalId = _stmt.isNull(_columnIndexOfResponderInternalId) ? null : _stmt.getText(_columnIndexOfResponderInternalId);
                    _item_1.setResponderInternalId(_tmpResponderInternalId);
                    String _tmpResponderPublicId = _stmt.isNull(_columnIndexOfResponderPublicId) ? null : _stmt.getText(_columnIndexOfResponderPublicId);
                    _item_1.setResponderPublicId(_tmpResponderPublicId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<JoinRequestEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<JoinRequestEntity> observeJoinRequestImpl(String joinRequestId) {
        String _sql = "SELECT * from joinRequest where joinRequestId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"joinRequest"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from joinRequest where joinRequestId = ?");){
                JoinRequestEntity _result;
                int _argIndex = 1;
                if (joinRequestId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, joinRequestId);
                }
                int _columnIndexOfJoinRequestId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"joinRequestId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdDate");
                int _columnIndexOfUpdatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedDate");
                int _columnIndexOfRequestorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorId");
                int _columnIndexOfRequestorInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorInternalId");
                int _columnIndexOfRequestorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorPublicId");
                int _columnIndexOfResponderId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderId");
                int _columnIndexOfResponderInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderInternalId");
                int _columnIndexOfResponderPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderPublicId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new JoinRequestEntity();
                    String _tmpJoinRequestId = _stmt.isNull(_columnIndexOfJoinRequestId) ? null : _stmt.getText(_columnIndexOfJoinRequestId);
                    _result.setJoinRequestId(_tmpJoinRequestId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _result.setNetworkId(_tmpNetworkId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedDate) ? null : _stmt.getText(_columnIndexOfCreatedDate);
                    DateTime _tmpCreatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedDate(_tmpCreatedDate);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedDate) ? null : _stmt.getText(_columnIndexOfUpdatedDate);
                    DateTime _tmpUpdatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedDate(_tmpUpdatedDate);
                    String _tmpRequestorId = _stmt.isNull(_columnIndexOfRequestorId) ? null : _stmt.getText(_columnIndexOfRequestorId);
                    _result.setRequestorId(_tmpRequestorId);
                    String _tmpRequestorInternalId = _stmt.isNull(_columnIndexOfRequestorInternalId) ? null : _stmt.getText(_columnIndexOfRequestorInternalId);
                    _result.setRequestorInternalId(_tmpRequestorInternalId);
                    String _tmpRequestorPublicId = _stmt.isNull(_columnIndexOfRequestorPublicId) ? null : _stmt.getText(_columnIndexOfRequestorPublicId);
                    _result.setRequestorPublicId(_tmpRequestorPublicId);
                    String _tmpResponderId = _stmt.isNull(_columnIndexOfResponderId) ? null : _stmt.getText(_columnIndexOfResponderId);
                    _result.setResponderId(_tmpResponderId);
                    String _tmpResponderInternalId = _stmt.isNull(_columnIndexOfResponderInternalId) ? null : _stmt.getText(_columnIndexOfResponderInternalId);
                    _result.setResponderInternalId(_tmpResponderInternalId);
                    String _tmpResponderPublicId = _stmt.isNull(_columnIndexOfResponderPublicId) ? null : _stmt.getText(_columnIndexOfResponderPublicId);
                    _result.setResponderPublicId(_tmpResponderPublicId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                JoinRequestEntity joinRequestEntity = _result;
                return joinRequestEntity;
            }
        });
    }

    @Override
    public List<JoinRequestEntity> getJoinRequestsByTargetIdImpl(String targetId) {
        String _sql = "SELECT * FROM joinRequest WHERE targetId = ?";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM joinRequest WHERE targetId = ?");){
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                int _columnIndexOfJoinRequestId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"joinRequestId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdDate");
                int _columnIndexOfUpdatedDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedDate");
                int _columnIndexOfRequestorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorId");
                int _columnIndexOfRequestorInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorInternalId");
                int _columnIndexOfRequestorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requestorPublicId");
                int _columnIndexOfResponderId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderId");
                int _columnIndexOfResponderInternalId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderInternalId");
                int _columnIndexOfResponderPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responderPublicId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<JoinRequestEntity> _result = new ArrayList<JoinRequestEntity>();
                while (_stmt.step()) {
                    JoinRequestEntity _item = new JoinRequestEntity();
                    String _tmpJoinRequestId = _stmt.isNull(_columnIndexOfJoinRequestId) ? null : _stmt.getText(_columnIndexOfJoinRequestId);
                    _item.setJoinRequestId(_tmpJoinRequestId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _item.setNetworkId(_tmpNetworkId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item.setTargetType(_tmpTargetType);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedDate) ? null : _stmt.getText(_columnIndexOfCreatedDate);
                    DateTime _tmpCreatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setCreatedDate(_tmpCreatedDate);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedDate) ? null : _stmt.getText(_columnIndexOfUpdatedDate);
                    DateTime _tmpUpdatedDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setUpdatedDate(_tmpUpdatedDate);
                    String _tmpRequestorId = _stmt.isNull(_columnIndexOfRequestorId) ? null : _stmt.getText(_columnIndexOfRequestorId);
                    _item.setRequestorId(_tmpRequestorId);
                    String _tmpRequestorInternalId = _stmt.isNull(_columnIndexOfRequestorInternalId) ? null : _stmt.getText(_columnIndexOfRequestorInternalId);
                    _item.setRequestorInternalId(_tmpRequestorInternalId);
                    String _tmpRequestorPublicId = _stmt.isNull(_columnIndexOfRequestorPublicId) ? null : _stmt.getText(_columnIndexOfRequestorPublicId);
                    _item.setRequestorPublicId(_tmpRequestorPublicId);
                    String _tmpResponderId = _stmt.isNull(_columnIndexOfResponderId) ? null : _stmt.getText(_columnIndexOfResponderId);
                    _item.setResponderId(_tmpResponderId);
                    String _tmpResponderInternalId = _stmt.isNull(_columnIndexOfResponderInternalId) ? null : _stmt.getText(_columnIndexOfResponderInternalId);
                    _item.setResponderInternalId(_tmpResponderInternalId);
                    String _tmpResponderPublicId = _stmt.isNull(_columnIndexOfResponderPublicId) ? null : _stmt.getText(_columnIndexOfResponderPublicId);
                    _item.setResponderPublicId(_tmpResponderPublicId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<JoinRequestEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from joinRequest";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from joinRequest");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateJoinRequestItem(String joinRequestId) {
        String _sql = "UPDATE joinRequest set joinRequestId = joinRequestId where joinRequestId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE joinRequest set joinRequestId = joinRequestId where joinRequestId = ?");){
                int _argIndex = 1;
                if (joinRequestId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, joinRequestId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateJoinRequestByTargetIdAndUserId(String targetId, String userId, String status) {
        String _sql = "UPDATE joinRequest SET status = ? WHERE targetId = ? AND userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE joinRequest SET status = ? WHERE targetId = ? AND userId = ?");){
                int _argIndex = 1;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void deleteJoinRequestByCommunityIdAndUserId(String targetId, String userId) {
        String _sql = "DELETE FROM joinRequest WHERE targetId = ? AND userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM joinRequest WHERE targetId = ? AND userId = ?");){
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

