package com.ekoapp.ekosdk.internal.usecase.invitation

import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository
import com.amity.socialcloud.sdk.core.domain.invitation.InvitationComposerUseCase
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import io.reactivex.rxjava3.core.Flowable

internal class ObserveMyCohostInvitationUseCase {

    fun execute(roomId: String): Flowable<AmityInvitation> {
        return InvitationRepository()
            .observeMyInvitation(roomId, "room")
            .map(InvitationComposerUseCase()::execute)
    }

}