package com.ekoapp.ekosdk.internal.usecase.invitation

import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository
import com.amity.socialcloud.sdk.core.domain.invitation.InvitationComposerUseCase
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import io.reactivex.rxjava3.core.Flowable

internal class ObserveInvitationsUseCase {

    fun execute(targetId: String, targetType: String): Flowable<List<AmityInvitation>> {
        return InvitationRepository()
            .observeInvitations(targetId, targetType)
            .map { model ->
                model.map(InvitationComposerUseCase()::execute)
            }
    }

}