package com.amity.socialcloud.sdk.video.domain.watch

import com.amity.socialcloud.sdk.video.data.watch.WatchSessionRepository
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal class UpdateWatchSessionUseCase {

    fun execute(sessionId: String, duration: Long, endedAt: DateTime): Completable {
        return updateSession(sessionId, duration, endedAt)
            .subscribeOn(Schedulers.io())
    }

    private fun updateSession(sessionId: String, duration: Long, endedAt: DateTime): Completable {
        return WatchSessionRepository().getById(sessionId)
            .firstOrError()
            .map { session ->
                session.watchSeconds = duration
                session.endTime = endedAt
                WatchSessionRepository().updateWatchSession(session)
            }.ignoreElement()
    }
}
