package com.amity.socialcloud.sdk.video.domain.watch

import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionRepository
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionSyncState
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

private const val MIN_JITTER = 5
private const val MAX_JITTER = 30

internal class SyncPendingWatchSessionsUseCase {

    fun execute() {
        jitter().flatMapCompletable {
            Completable.fromAction { WatchSessionRepository().resetSyncState() }
                    .andThen(queryPendingSyncSession())
                    .flatMapCompletable { sendToServer(it) }
        }.subscribeOn(Schedulers.io())
                .subscribe()
    }

    private fun sendToServer(watchSessions: List<WatchSessionEntity>): Completable {
        return SendWatchSessionUseCase().execute(watchSessions, true)
                .subscribeOn(Schedulers.io())
    }

    private fun jitter(): Single<Long> {
        val jitter = (MIN_JITTER..MAX_JITTER).random().toLong()
        return Single.timer(jitter, TimeUnit.SECONDS, Schedulers.io())
    }

    private fun queryPendingSyncSession(): Single<List<WatchSessionEntity>> {
        return WatchSessionRepository().getWatchSessionCollection(arrayOf(WatchSessionSyncState.PENDING)).firstOrError()
    }
}
