package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class RoomLiveObjectUseCase : LiveObjectUseCase<RoomEntity, AmityRoom>() {

    override fun createRepository(): AmityObjectRepository<RoomEntity, AmityRoom> = RoomRepository()

    override fun composeModel(model: AmityRoom): AmityRoom = RoomComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.POST
}