package com.amity.socialcloud.sdk.video.data.watch

import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity
import com.ekoapp.ekosdk.EkoObjectRepository
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

internal class WatchSessionRepository : EkoObjectRepository() {

    fun getWatchSessionCollection(syncStateArray: Array<WatchSessionSyncState>): Flowable<List<WatchSessionEntity>> {
        val watchDao = UserDatabase.get().watchSessionDao()
        val syncStateList = arrayListOf<String>()
        syncStateArray.forEach { syncStateList.add(it.key) }
        return watchDao.getAll(syncStateList.toTypedArray())
    }

    fun getById(sessionId: String): Flowable<WatchSessionEntity> {
        val watchDao = UserDatabase.get().watchSessionDao()
        return watchDao.getById(sessionId)
    }

    fun resetSyncState() {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchDao.updateSyncState(WatchSessionSyncState.SYNCING, WatchSessionSyncState.PENDING)
    }

    fun createWatchSession(sessionId: String, roomId: String, startedAt: DateTime) {
        val watchDao = UserDatabase.get().watchSessionDao()
        val watchSession = WatchSessionEntity()
        watchSession.sessionId = sessionId
        watchSession.roomId = roomId
        watchSession.startTime = startedAt
        watchDao.insert(watchSession)
    }

    fun updateWatchSession(watchEntity: WatchSessionEntity) {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchDao.update(watchEntity)
    }

    fun markAsSyncing(watchEntities: List<WatchSessionEntity>) {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchEntities.forEach { it.syncState = WatchSessionSyncState.SYNCING.key }
        watchDao.update(watchEntities)
    }

    fun markAsSynced(watchEntities: List<WatchSessionEntity>) {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchEntities.forEach { 
            it.syncState = WatchSessionSyncState.SYNCED.key
            it.syncedAt = DateTime.now()
        }
        watchDao.update(watchEntities)
    }

    fun markAsFailed(watchEntities: List<WatchSessionEntity>) {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchEntities.forEach {
            it.syncState = WatchSessionSyncState.PENDING.key
            it.retryCount++
        }
        watchDao.update(watchEntities)
        deleteIfExceedRetry(watchEntities)
    }

    private fun deleteIfExceedRetry(watchEntities: List<WatchSessionEntity>) {
        val watchDao = UserDatabase.get().watchSessionDao()
        watchEntities.forEach {
            if (it.retryCount >= MAX_RETRY) {
                watchDao.delete(it)
            }
        }
    }
}

const val MAX_RETRY = 3
