package com.amity.socialcloud.sdk.model.social.notification

import com.amity.socialcloud.sdk.model.core.notification.AmityRolesFilter
import com.amity.socialcloud.sdk.model.core.role.AmityRoles

sealed class AmityCommunityNotificationEvent(private val isEnabled: Boolean,
                                             private val isNetworkEnabled: Boolean,
                                             private val rolesFilter: AmityRolesFilter
) {

    fun isEnabled(): Boolean {
        return isEnabled
    }

    fun getRolesFilter(): AmityRolesFilter {
        return rolesFilter
    }

    fun isNetworkEnabled(): Boolean {
        return isNetworkEnabled
    }

    class POST_CREATED(isEnabled: Boolean,
                       isNetworkEnabled: Boolean,
                       rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {

            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.POST_CREATED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.POST_CREATED, false)
            }
        }
    }

    class POST_REACTED(isEnabled: Boolean,
                       isNetworkEnabled: Boolean,
                       rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.POST_REACTED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.POST_REACTED, false)
            }
        }
    }

    class COMMENT_CREATED(isEnabled: Boolean,
                          isNetworkEnabled: Boolean,
                          rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_CREATED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_CREATED, false)
            }
        }
    }

    class COMMENT_REACTED(isEnabled: Boolean,
                          isNetworkEnabled: Boolean,
                          rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_REACTED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_REACTED, false)
            }
        }
    }

    class COMMENT_REPLIED(isEnabled: Boolean,
                          isNetworkEnabled: Boolean,
                          rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_REPLIED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.COMMENT_REPLIED, false)
            }
        }
    }

    class STORY_CREATED(isEnabled: Boolean,
                          isNetworkEnabled: Boolean,
                          rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_CREATED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_CREATED, false)
            }
        }
    }

    class STORY_REACTED(isEnabled: Boolean,
                        isNetworkEnabled: Boolean,
                        rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_REACTED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_REACTED, false)
            }
        }
    }

    class STORY_COMMENT_CREATED(isEnabled: Boolean,
                        isNetworkEnabled: Boolean,
                        rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_COMMENT_CREATED, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.STORY_COMMENT_CREATED, false)
            }
        }
    }

    class LIVESTREAM_START(isEnabled: Boolean,
                                isNetworkEnabled: Boolean,
                                rolesFilter: AmityRolesFilter
    )
        : AmityCommunityNotificationEvent(isEnabled, isNetworkEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.LIVESTREAM_START, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityCommunityNotificationEventName.LIVESTREAM_START, false)
            }
        }
    }

    class MODIFIER internal constructor(private val eventName: AmityCommunityNotificationEventName,
                                        private val isEnabled: Boolean,
                                        rolesFilter: AmityRolesFilter? = null) {

        private var includedRoles: AmityRoles? = null
        private var excludedRoles: AmityRoles? = null

        init {
            when (rolesFilter) {
                is AmityRolesFilter.ONLY -> {
                    this.includedRoles = rolesFilter.getRoles()
                }
                is AmityRolesFilter.NOT -> {
                    this.excludedRoles = rolesFilter.getRoles()
                }
                else -> {
                    this.includedRoles = AmityRoles()
                    //this.excludedRoles = AmityRoles()
                }
            }
        }

        internal fun getEventName(): AmityCommunityNotificationEventName {
            return eventName
        }

        internal fun isEnabled(): Boolean {
            return isEnabled
        }

        internal fun getIncludedRoles(): AmityRoles? {
            return includedRoles
        }

        internal fun getExcludedRoles(): AmityRoles? {
            return excludedRoles
        }

    }

}