package com.amity.socialcloud.sdk.api.social.post.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityGlobalFeedQuery internal constructor(
    private val dataTypes: List<AmityPost.DataType>? = null,
    private val includeMixedStructure: Boolean
){

    /**
     * Queries for Global feed.
     * @return Flowable<PagingData<AmityPost>>.
     */
    fun query(): Flowable<PagingData<AmityPost>> {
        return GetGlobalFeedPagingDataUseCase().execute(
            dataTypes = dataTypes ?: listOf(),
            includeMixedStructure = includeMixedStructure
        )
    }

    class Builder internal constructor(){
        private var dataTypes: List<AmityPost.DataType> = listOf()
        private var includeMixedStructure: Boolean = false

        /**
         * Specifies [dataTypes] to filter matching dataType.
         * @return the same Builder instance.
         */
        fun dataTypes(dataTypes: List<AmityPost.DataType>): Builder {
            return apply { this.dataTypes = dataTypes }
        }

        fun includeMixedStructure(includeMixedStructure: Boolean): Builder {
            return apply { this.includeMixedStructure = includeMixedStructure }
        }

        /**
         * Instantiates AmityGlobalFeedQuery with built params.
         * @return new instance of AmityGlobalFeedQuery.
         */
        fun build(): AmityGlobalFeedQuery {
            return AmityGlobalFeedQuery(
                dataTypes = dataTypes,
                includeMixedStructure = includeMixedStructure,
            )
        }
    }

}