/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.http.request;

import android.util.Base64;
import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.http.request.WatchSession;
import com.ekoapp.ekosdk.internal.api.http.request.WatchSessionRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ekoapp/ekosdk/internal/api/http/request/WatchSessionRequestCreator;", "", "watchSessionEntityList", "", "Lcom/amity/socialcloud/sdk/entity/video/watch/WatchSessionEntity;", "<init>", "(Ljava/util/List;)V", "create", "Lcom/ekoapp/ekosdk/internal/api/http/request/WatchSessionRequest;", "getWatchSessionList", "Lcom/ekoapp/ekosdk/internal/api/http/request/WatchSession;", "createDataString", "", "watchSessionList", "composeUnsignedString", "nonceString", "timeStampString", "dataString", "createSignature", "plainText", "getPrivateKey", "Ljava/security/PrivateKey;", "generateNonceString", "getSecretKey", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nWatchSessionRequestCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WatchSessionRequestCreator.kt\ncom/ekoapp/ekosdk/internal/api/http/request/WatchSessionRequestCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1869#2,2:152\n1056#2:154\n1878#2,3:155\n*S KotlinDebug\n*F\n+ 1 WatchSessionRequestCreator.kt\ncom/ekoapp/ekosdk/internal/api/http/request/WatchSessionRequestCreator\n*L\n30#1:152,2\n39#1:154\n45#1:155,3\n*E\n"})
public final class WatchSessionRequestCreator {
    @NotNull
    private final List<WatchSessionEntity> watchSessionEntityList;

    public WatchSessionRequestCreator(@NotNull List<WatchSessionEntity> watchSessionEntityList) {
        Intrinsics.checkNotNullParameter(watchSessionEntityList, (String)"watchSessionEntityList");
        this.watchSessionEntityList = watchSessionEntityList;
    }

    @NotNull
    public final WatchSessionRequest create() {
        List<WatchSession> watchSessionList = this.getWatchSessionList();
        String nonceString = this.generateNonceString();
        String string = DateTime.now().withZone(DateTimeZone.UTC).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String timeStampString = string;
        String dataString = this.createDataString(watchSessionList);
        String unsignedString = this.composeUnsignedString(nonceString, timeStampString, dataString);
        String signedString = this.createSignature(unsignedString);
        return WatchSessionRequest.Companion.create(signedString, nonceString, timeStampString, watchSessionList);
    }

    private final List<WatchSession> getWatchSessionList() {
        ArrayList<WatchSession> watchSessionList = new ArrayList<WatchSession>();
        Iterable $this$forEach$iv = this.watchSessionEntityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String endTime;
            WatchSessionEntity entity = (WatchSessionEntity)element$iv;
            boolean bl = false;
            DateTime dateTime = entity.getStartTime();
            String startTime = dateTime != null && (dateTime = dateTime.withZone(DateTimeZone.UTC)) != null && (dateTime = dateTime.toDateTimeISO()) != null ? dateTime.toString() : null;
            DateTime dateTime2 = entity.getEndTime();
            String string = dateTime2 != null && (dateTime2 = dateTime2.withZone(DateTimeZone.UTC)) != null ? dateTime2.toString() : (endTime = null);
            if (startTime == null || endTime == null) continue;
            WatchSession watchSession = WatchSession.Companion.create(entity.getSessionId(), entity.getRoomId(), startTime, endTime, entity.getWatchSeconds());
            watchSessionList.add(watchSession);
        }
        Iterable $this$sortedBy$iv = watchSessionList;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                WatchSession it = (WatchSession)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getStartTime());
                it = (WatchSession)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getStartTime())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String createDataString(List<WatchSession> watchSessionList) {
        StringBuilder accumulatedString = new StringBuilder();
        Iterable $this$forEachIndexed$iv = watchSessionList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void watchSession;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WatchSession watchSession2 = (WatchSession)item$iv;
            int index = n;
            boolean bl = false;
            boolean isLastIndex = index == watchSessionList.size() - 1;
            StringBuilder sessionStringData = new StringBuilder().append("endTime=" + watchSession.getEndTime() + "&").append("roomId=" + watchSession.getRoomId() + "&").append("sessionId=" + watchSession.getSessionId() + "&").append("startTime=" + watchSession.getStartTime() + "&").append("watchSeconds=" + watchSession.getWatchSeconds());
            accumulatedString.append((CharSequence)sessionStringData);
            if (isLastIndex) continue;
            accumulatedString.append(";");
        }
        String string = accumulatedString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String composeUnsignedString(String nonceString, String timeStampString, String dataString) {
        String string = "nonceStr=" + nonceString + "&" + ("timestamp=" + timeStampString + "&") + ("data=" + dataString + "==");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String createSignature(String plainText) throws Exception {
        Signature privateSignature = Signature.getInstance("SHA256withRSA");
        privateSignature.initSign(this.getPrivateKey());
        String string = plainText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        privateSignature.update(byArray);
        byte[] signature = privateSignature.sign();
        String string2 = Base64.encodeToString((byte[])signature, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private final PrivateKey getPrivateKey() {
        byte[] byArray = Base64.decode((String)this.getSecretKey(), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] keyBytes = byArray;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory fact = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = fact.generatePrivate(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"generatePrivate(...)");
        return privateKey;
    }

    private final String generateNonceString() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getSecretKey() {
        return Intrinsics.areEqual((Object)EkoEndpoint.INSTANCE.getHttpUrl(), (Object)"https://api.staging.amity.co/") || Intrinsics.areEqual((Object)EkoEndpoint.INSTANCE.getHttpUrl(), (Object)"https://api.dev.amity.co/") ? "MIIEpQIBAAKCAQEAwAEc/oZgYIvKSUG/C3mONYLR4ZPgAjMEX4bJ+xqqakUDRtql\nNO+eZs2blQ1Ko0DBkqPExyQezvjibH5W2UZBV5RaBTlTcNVKTToMBEGesAfaEcM3\nqUyQHxdbFYZv6P4sb14dcwxTQ8usmaV8ooiR1Fcaso5ZWYcZ8Hb46FbQ7OoVumsB\ntPWwfZ4f003o5VCl6AIM6lcLv9UDLlFVYhE+PeXpRHtfWlGqxMvqC9oinlwhL6nW\nv6VjQXW4nhcib72dPBzfHT7k/PMKto2SxALYdb68ENiAGuJLWi3AUHSyYCJK2w7w\nIlWfJUAI0v26ub10IpExr6D5QuW2577jjP93iwIDAQABAoIBAFWfqXhwIIatkFY+\n9Z1+ZcbDQimgsmMIsUiQaX6Lk7e0cxOj6czDlxYtVtaPiNtow2pLkjNkjkCqiP7t\nEHnwdK9DvylZOTa2R15NJpK3WLcTqVIGhsn/FL5owfvFah6zSsmXZParZm5zY9NZ\nE03ALZhOB9/cz0e3kf/EbpfeL2mW7MApyiUt5i09ycchroOpcWp73ipIxvgigtZy\nUGFmsQicWhUs28F0D7w4Qfk76yG3nqXeb+BAMhCaIaa/k/aAxhiZG/ygEQWQrcC8\ngfe+jyicMAQPDEVS9YuUMGsLjIjKuVLZzp2xirQnhc2i2zVNEIvG6soprPOBEMQu\ngzrtX5ECgYEA3b7KAbBIbDl1e4ZSCWhHdHkiWVZHaopsR/LhqDDNhXjWjq3AesgV\n6k0j9EdziMn/HmmOso0bz99GTV3JZf4A9ztTLumJlkHbdVtlgOqSjrFLj12rH9KX\nTheyIhWSpUmm8+WB1xasFbqpvJaGo7F3pd2Fqj1XR4mp5BO7c/t7LJ0CgYEA3aou\nEzXQ9THRKYocdfY69EI1Il1t/d/RSqqd9BxEjxBgxkM13ZiYIn/R4WW/nCUrlmhx\nG44Aa2Gob4Ahfsui2xKTg/g/3Zk/rAxAEGkfOLGoenaJMD41fH4wUq3FRYwkvnaM\nb9Hd6f/TlBHslIRa2NN58bSBGJCyBP2b59+2+EcCgYEAixDVRXvV37GlYUOa/XVd\nosk5Zoe6oDGRuQm0xbNdoUBoZvDHDvme7ONWEiQha/8qtVsD+CyQ7awcPfb8kK9c\n0bBt+bTS6d4BkTcxkEkMgtrkBVR8Nqfu5jXsLH4VCv4G61zbMhZw8+ut+az5YX2y\nCN7Frj9sFlxapMRPQmzMEe0CgYEAumsAzM8ZqNv4mAK65Mnr0rhLj1cbxcKRdUYA\nCOgtEFQpzxN/HZnTeFAe5nx3pI3uFlRHq3DFEYnT6dHMWaJQmAULYpVIwMi9L6gt\nyJ9fzoI6uqMtxRDMUqKdaSsTGOY/kJ6KhQ/unXi1K3XXjR+yd1+C0q+HUm1+CYxv\nrZYLfskCgYEArsEy+IQOiqniJ0NE2vVUF+UK/IRZaic9YKcpov5Ot7Vvzm/MnnW4\nN1ljVskocETBWMmPUvNSExVjPebi+rxd8fa5kY8BJScPTzMFbunZn/wjtGdcM10q\ndlVQ9doG61A/9P3ezFKCfS4AvF/H/59LcSx2Bh28fp3/efiVIOpVd4Y=" : "MIIEowIBAAKCAQEAx6PNEnnB+xbhdoRWJ2/pduv1TfFDC1wEBS58XIjUxMJBlRTK\nXXs5R/K1Nh7VCS+ERE6IGwDi1WNFzI7OrD5/BtZwC5ofang6VLVahTlbQR8RGfdd\nEyzrUIrp46iSjuZ1name9RAtzhZbkYhkJDvOAYiBW79+7m+8Zd0vF2q27SqC3Mla\nZAx4vtcMdaYAgJ+oLQVIHJDy+TUfIy7Hmm5dxwF0H4UwiqOLZjhTNg8cJdSFDJiC\nayYP2iFP1NLY/9RKKO5htCXDVl9fZVtxHnAm4tJ3AiTq5FHcJQa3I2jGsml/7mxM\nMlHkxoi3cnOC9xkSx48ivMYFTV0TB22VidmuTQIDAQABAoIBAEsbhPt+c0xTv18n\nSoJryBnFi/RW4DJV2+1XH9JwaBveOW4s9DVXNqWq2iISV3OtPMW2Bd6i5rQBNTFQ\nSNDkckXQRzcWNNuJf+h+kh+tBHfriDOMrKeaLq2OlY/gy8KXUYiPWA46mAEAyFJo\nTcST+1z4TjKGSOrLfsWUATN+InP27wDEiZvTmaYUqd/ql1ZBWc7a9psQ9hGUiSS2\nMYvAQnYDNqoWs2pW3CeswyhwmVlVpvEUcQxpXcjG/9t+ycRE8z+NLQJczmQ5gQG1\nIBJ7qwyfd0VQyBN622VLIcIHkHdfGnptPeploLwdQCCmILEwEd6cPldfWFgI6v4J\nT+n8/MECgYEA/6EKvrpChdD0YAXjOYHk40sLHRqaUC5n+Z3bo76Is/06XYwxD7uk\nfJIoEK9axtreCv8n3WaCPEXZiQ9Wpd0OzfYaH6KEsuK4+hN7cc1mQhyYx2ndnJwq\nfztuh4kXhgJe8E3H05jXYhR4WUM5uSQZL1gIsLr0DDXxG518cOv7yA8CgYEAx+31\n/ILHO+yS7wFoKdTGkDf7G6lW+iXk9RUH0fBP1hQkps0AbTc3eSoGLgnnpcK//A8m\nMrbzdgcwmGV6e94CNYxd2JVuY1Z++DmOk8ENPeXYoMKOmdMrsaKXSDgKSoAJC/T0\nSoDa6gH9zQMjLmupThon84w6IwtylH8pUJsTJ+MCgYB6dgfTvx9HRAcOSUPFtPiV\n+slkM+5hIxokdv9Vvl12/IUNc6+9PcNa+hm/hIIUaZ2d3waWBhm2DjBcfMChzPje\nqltxdEXl/L9o7hRhPGkUmuaGAa1s7VNeiHY27/IY/OHGdTyZncrw7aWJ/a6VhzmZ\neK8RGz726pCLDjMjVanU+QKBgDkoHpsCCFNpXthVXqIW4m14k6Fk2CjLjJlEWef6\n+9gICjJliSmwD3vkN8ARtNf+xUQaUKFPDGtBwvLOkCW5YohMiMfScKyVndb5HXnA\nRzja7QOIm5v+cw9lnDpZSxfhYrS4Yt6p1+vuhdCGhRhQTya085b9D+HU8/zgHb+d\nlexhAoGBANk7bTigQKlpZYDmmTpKpS1TCVZoEe7OrS4tfnBD/GXGqVfWkW0c0wCl\n5uH/ABIbZRvRfZAjrx2AmBouiWoliWZB43nsd0/nhOg4usuQZvyH7eY7VYSeIwlc\nBzikzHo+/TT1BUyX7/IQqNvYWgQ7+kVxa7/k9tSgnMPJN7CXiVlk";
    }
}

