/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.domain.watch;

import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus;
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionRepository;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/amity/socialcloud/sdk/video/domain/watch/CreateWatchSessionUseCase;", "", "<init>", "()V", "execute", "Lio/reactivex/rxjava3/core/Single;", "", "room", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "startedAt", "Lorg/joda/time/DateTime;", "insertSession", "", "sessionId", "roomId", "amity-sdk_release"})
public final class CreateWatchSessionUseCase {
    @NotNull
    public final Single<String> execute(@NotNull AmityRoom room, @NotNull DateTime startedAt) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Single single = Single.fromCallable(() -> CreateWatchSessionUseCase.execute$lambda$0(room, this, startedAt)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    private final void insertSession(String sessionId, String roomId, DateTime startedAt) {
        new WatchSessionRepository().createWatchSession(sessionId, roomId, startedAt);
    }

    private static final String execute$lambda$0(AmityRoom $room, CreateWatchSessionUseCase this$0, DateTime $startedAt) {
        String prefix = switch (WhenMappings.$EnumSwitchMapping$0[$room.getStatus().ordinal()]) {
            case 1 -> "live_";
            case 2 -> "playback_";
            default -> throw AmityException.Companion.create$default(AmityException.Companion, "room is not in watchable state", null, AmityError.BUSINESS_ERROR, null, 8, null);
        };
        String sessionId = prefix + new ObjectId(null, 1, null).toHexString();
        this$0.insertSession(sessionId, $room.getRoomId(), $startedAt);
        return sessionId;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityRoomStatus.values().length];
            try {
                nArray[AmityRoomStatus.LIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityRoomStatus.RECORDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

