/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import co.amity.rxbridge.SingleKt;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.exception.EntityNotFoundException;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.AmityUserType;
import com.amity.socialcloud.sdk.model.core.user.AmityUserTypeKt;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\fJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018J\u0006\u0010\u0019\u001a\u00020\fJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018J@\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0002J@\u0010 \u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "<init>", "()V", "ABOUT_TO_EXPIRE_TRESHOLD", "", "getActiveUserId", "", "getVisitorDeviceId", "getActiveUserType", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUserType;", "login", "Lio/reactivex/rxjava3/core/Completable;", "userId", "displayName", "authToken", "isLegacyVersion", "", "loginVisitor", "authSignature", "authSignatureExpiresAt", "Lorg/joda/time/DateTime;", "logout", "revokeAccessToken", "Lio/reactivex/rxjava3/core/Single;", "clearData", "getCurrentAccount", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "renewToken", "account", "activateAccount", "activateVisitor", "renewTokenIfNeed", "verifyCurrentAccessToken", "updateDisplayNameIfNeeded", "", "amity-sdk_release"})
public final class SessionRepository
extends EkoObjectRepository {
    private final double ABOUT_TO_EXPIRE_TRESHOLD;

    public SessionRepository() {
        this.ABOUT_TO_EXPIRE_TRESHOLD = 0.8;
    }

    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final String getVisitorDeviceId() {
        return new SessionLocalDataStore().getVisitorDeviceId();
    }

    @NotNull
    public final AmityUserType getActiveUserType() {
        return new SessionLocalDataStore().getActiveUserType();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = this.activateAccount(userId).flatMapCompletable(new Function(this, displayName, authToken, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            public final CompletableSource apply(EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, it, this.$displayName, this.$authToken, null, null, this.$isLegacyVersion);
            }
        }).doOnComplete(() -> SessionRepository.login$lambda$0(this, userId, displayName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnComplete(...)");
        return completable;
    }

    @NotNull
    public final Completable loginVisitor(@Nullable String displayName, @Nullable String authSignature, @Nullable DateTime authSignatureExpiresAt) {
        Completable completable = this.activateVisitor().flatMapCompletable(new Function(this, displayName, authSignature, authSignatureExpiresAt){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            {
                this.this$0 = $receiver;
                this.$displayName = $displayName;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
            }

            public final CompletableSource apply(EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)SessionRepository.access$renewTokenIfNeed(this.this$0, it, this.$displayName, null, this.$authSignature, this.$authSignatureExpiresAt, false);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable logout() {
        Completable completable = Completable.fromAction(SessionRepository::logout$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Single<Boolean> revokeAccessToken() {
        return new SessionRemoteDataStore().revokeAccessToken();
    }

    @NotNull
    public final Completable clearData() {
        Completable completable = new DeviceNotificationRepository().unregisterAll().andThen((CompletableSource)Completable.fromAction(SessionRepository::clearData$lambda$2).subscribeOn(Schedulers.io()));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        return completable;
    }

    @NotNull
    public final Single<EkoAccount> getCurrentAccount() {
        Single single = Single.create(SessionRepository::getCurrentAccount$lambda$3).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    @NotNull
    public final Completable renewToken(@NotNull EkoAccount account, @Nullable String displayName, @Nullable String authToken, @Nullable String authSignature, @Nullable DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account, displayName, authSignature, authSignatureExpiresAt, authToken, isLegacyVersion, this){
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            final /* synthetic */ String $authToken;
            final /* synthetic */ boolean $isLegacyVersion;
            final /* synthetic */ SessionRepository this$0;
            {
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
                this.$authToken = $authToken;
                this.$isLegacyVersion = $isLegacyVersion;
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(EkoApiKey it) {
                Single<RegisterDeviceDto> single;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityUserTypeKt.isVisitor(this.$account)) {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    String string2 = this.$account.getDeviceId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceId(...)");
                    single = sessionRemoteDataStore.registerVisitor(string, this.$displayName, string2, this.$authSignature, this.$authSignatureExpiresAt);
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    String string3 = this.$account.getUserId();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserId(...)");
                    String string4 = this.$account.getDeviceId();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDeviceId(...)");
                    single = sessionRemoteDataStore.registerDevice(string, string3, this.$displayName, string4, this.$authToken, this.$isLegacyVersion);
                }
                io.reactivex.Single single2 = SingleKt.toRx2(single).retryWhen(RetryWhen.retryIf(renewToken.1::apply$lambda$0).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build());
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"retryWhen(...)");
                return (CompletableSource)SingleKt.toRx3((io.reactivex.Single)single2).flatMapCompletable(new Function(this.$account, this.$isLegacyVersion, this.this$0){
                    final /* synthetic */ EkoAccount $account;
                    final /* synthetic */ boolean $isLegacyVersion;
                    final /* synthetic */ SessionRepository this$0;
                    {
                        this.$account = $account;
                        this.$isLegacyVersion = $isLegacyVersion;
                        this.this$0 = $receiver;
                    }

                    public final CompletableSource apply(RegisterDeviceDto it) {
                        EkoUserListDto ekoUserListDto;
                        this.$account.setRefreshToken(it.getRefreshToken());
                        this.$account.setAccessToken(it.getAccessToken());
                        if (this.$isLegacyVersion) {
                            this.$account.setIssuedAt(DateTime.now());
                            this.$account.setExpiresAt(DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L)));
                        } else {
                            this.$account.setIssuedAt(it.getIssuedAt());
                            this.$account.setExpiresAt(it.getExpiresAt());
                        }
                        double tokenDuration = (double)(this.$account.getExpiresAt().getMillis() - this.$account.getIssuedAt().getMillis() - (long)CoreClient.INSTANCE.getMillisTimeDiff$amity_sdk_release()) * SessionRepository.access$getABOUT_TO_EXPIRE_TRESHOLD$p(this.this$0);
                        this.$account.setAboutToExpireAt(this.$account.getIssuedAt().plus((long)tokenDuration));
                        Object[] objectArray = new Object[]{"token renewed: account updated : \n       expiresAt = " + this.$account.getExpiresAt() + " \naboutToExpireAt = " + this.$account.getAboutToExpireAt() + "\n       issuedAt = " + this.$account.getIssuedAt() + "\nduration: = " + tokenDuration / (double)1000 + " sec "};
                        AmityLog.INSTANCE.e("SSM3", objectArray);
                        EkoUserListDto $this$apply_u24lambda_u240 = ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        List list = it.getUsers();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setUsers(list);
                        List list2 = it.getFiles();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply_u24lambda_u240.setFiles(list2);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                }).doOnError(new Consumer(this.$account){
                    final /* synthetic */ EkoAccount $account;
                    {
                        this.$account = $account;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SessionLocalDataStore sessionLocalDataStore = new SessionLocalDataStore();
                        String string = this.$account.getUserId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserId(...)");
                        sessionLocalDataStore.logoutAccount(string);
                    }
                });
            }

            private static final boolean apply$lambda$0(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) != AmityError.USER_IS_GLOBAL_BANNED;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    public static /* synthetic */ Completable renewToken$default(SessionRepository sessionRepository, EkoAccount ekoAccount, String string, String string2, String string3, DateTime dateTime, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sessionRepository.renewToken(ekoAccount, string, string2, string3, dateTime, bl);
    }

    private final Single<EkoAccount> activateAccount(String userId) {
        Single single = Single.fromCallable(() -> SessionRepository.activateAccount$lambda$4(userId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    private final Single<EkoAccount> activateVisitor() {
        Single single = Single.fromCallable(SessionRepository::activateVisitor$lambda$5).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"subscribeOn(...)");
        return single;
    }

    private final Completable renewTokenIfNeed(EkoAccount account, String displayName, String authToken, String authSignature, DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext(new Function(this, account, displayName, authToken, authSignature, authSignatureExpiresAt, isLegacyVersion){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            final /* synthetic */ boolean $isLegacyVersion;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$displayName = $displayName;
                this.$authToken = $authToken;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
                this.$isLegacyVersion = $isLegacyVersion;
            }

            public final CompletableSource apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)this.this$0.renewToken(this.$account, this.$displayName, this.$authToken, this.$authSignature, this.$authSignatureExpiresAt, this.$isLegacyVersion);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable(new Function(account){
            final /* synthetic */ EkoAccount $account;
            {
                this.$account = $account;
            }

            public final CompletableSource apply(EkoApiKey it) {
                CompletableSource completableSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$account.getAccessToken() == null) {
                    completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, "accessToken not found", null, AmityError.UNAUTHORIZED_ERROR, null, 8, null));
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    String string = it.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                    completableSource = (CompletableSource)sessionRemoteDataStore.verifyAccessToken(string);
                }
                return completableSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observe(userId).firstOrError().flatMapCompletable(new Function(displayName, userId){
                final /* synthetic */ String $displayName;
                final /* synthetic */ String $userId;
                {
                    this.$displayName = $displayName;
                    this.$userId = $userId;
                }

                public final CompletableSource apply(AmityUser it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser(this.$userId, new UserUpdateOption(this.$displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
                }
            }).subscribeOn(Schedulers.io()).doOnError((Consumer)updateDisplayNameIfNeeded.2.INSTANCE).subscribe();
        }
    }

    private static final void login$lambda$0(SessionRepository this$0, String $userId, String $displayName) {
        this$0.updateDisplayNameIfNeeded($userId, $displayName);
    }

    private static final void logout$lambda$1() {
        CoreClient.INSTANCE.publishLogoutEvent();
    }

    private static final void clearData$lambda$2() {
        new SessionLocalDataStore().logoutAccount(new SessionLocalDataStore().getActiveUserId());
    }

    private static final void getCurrentAccount$lambda$3(SingleEmitter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EkoAccount account = new SessionLocalDataStore().getCurrentAccount();
        if (account != null) {
            it.onSuccess((Object)account);
        } else {
            it.onError((Throwable)EntityNotFoundException.INSTANCE);
        }
    }

    private static final EkoAccount activateAccount$lambda$4(String $userId) {
        return new SessionLocalDataStore().activateAccount($userId);
    }

    private static final EkoAccount activateVisitor$lambda$5() {
        return new SessionLocalDataStore().activateVisitorAccount();
    }

    public static final /* synthetic */ Completable access$renewTokenIfNeed(SessionRepository $this, EkoAccount account, String displayName, String authToken, String authSignature, DateTime authSignatureExpiresAt, boolean isLegacyVersion) {
        return $this.renewTokenIfNeed(account, displayName, authToken, authSignature, authSignatureExpiresAt, isLegacyVersion);
    }

    public static final /* synthetic */ double access$getABOUT_TO_EXPIRE_TRESHOLD$p(SessionRepository $this) {
        return $this.ABOUT_TO_EXPIRE_TRESHOLD;
    }
}

