/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.video.room;

import com.amity.socialcloud.sdk.api.video.room.query.AmityRoomQuery;
import com.amity.socialcloud.sdk.core.session.eventbus.CoHostEventBus;
import com.amity.socialcloud.sdk.core.session.model.AmityCoHostEvent;
import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomBroadcastData;
import com.amity.socialcloud.sdk.video.domain.room.CreateRoomUseCase;
import com.amity.socialcloud.sdk.video.domain.room.DeleteRoomUseCase;
import com.amity.socialcloud.sdk.video.domain.room.FetchRoomUseCase;
import com.amity.socialcloud.sdk.video.domain.room.GetBroadcasterDataUseCase;
import com.amity.socialcloud.sdk.video.domain.room.GetRecordedUrlsUseCase;
import com.amity.socialcloud.sdk.video.domain.room.LeaveRoomUseCase;
import com.amity.socialcloud.sdk.video.domain.room.RemoveRoomParticipantUseCase;
import com.amity.socialcloud.sdk.video.domain.room.RoomLiveObjectUseCase;
import com.amity.socialcloud.sdk.video.domain.room.StopRoomUseCase;
import com.amity.socialcloud.sdk.video.domain.room.UpdateRoomUseCase;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJe\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018\u00a2\u0006\u0002\u0010\u0019JU\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000e2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00180\u000e2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006&"}, d2={"Lcom/amity/socialcloud/sdk/api/video/room/AmityRoomRepository;", "", "<init>", "()V", "getRooms", "Lcom/amity/socialcloud/sdk/api/video/room/query/AmityRoomQuery$Builder;", "getRoom", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "roomId", "", "fetchRoom", "Lio/reactivex/rxjava3/core/Completable;", "createRoom", "Lio/reactivex/rxjava3/core/Single;", "title", "description", "thumbnailFileId", "metadata", "Lcom/google/gson/JsonObject;", "liveChatEnabled", "", "parentRoomId", "participants", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;Ljava/lang/String;Ljava/util/List;)Lio/reactivex/rxjava3/core/Single;", "updateRoom", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "deleteRoom", "stopRoom", "getBroadcasterData", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomBroadcastData;", "getRecordedUrls", "leaveRoom", "removeRoomParticipant", "userId", "getCoHostEvent", "Lcom/amity/socialcloud/sdk/core/session/model/AmityCoHostEvent;", "amity-sdk_release"})
public final class AmityRoomRepository {
    @NotNull
    public final AmityRoomQuery.Builder getRooms() {
        return new AmityRoomQuery.Builder();
    }

    @NotNull
    public final Flowable<AmityRoom> getRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new RoomLiveObjectUseCase().execute(roomId);
    }

    @NotNull
    public final Completable fetchRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new FetchRoomUseCase().execute(roomId);
    }

    @NotNull
    public final Single<AmityRoom> createRoom(@NotNull String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean liveChatEnabled, @Nullable String parentRoomId, @NotNull List<String> participants) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return new CreateRoomUseCase().execute(title, description, thumbnailFileId, metadata, liveChatEnabled, parentRoomId, participants);
    }

    public static /* synthetic */ Single createRoom$default(AmityRoomRepository amityRoomRepository, String string, String string2, String string3, JsonObject jsonObject, Boolean bl, String string4, List list, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            jsonObject = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        return amityRoomRepository.createRoom(string, string2, string3, jsonObject, bl, string4, list);
    }

    @NotNull
    public final Single<AmityRoom> updateRoom(@NotNull String roomId, @Nullable String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean liveChatEnabled) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new UpdateRoomUseCase().execute(roomId, title, description, thumbnailFileId, metadata, liveChatEnabled);
    }

    public static /* synthetic */ Single updateRoom$default(AmityRoomRepository amityRoomRepository, String string, String string2, String string3, String string4, JsonObject jsonObject, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            jsonObject = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        return amityRoomRepository.updateRoom(string, string2, string3, string4, jsonObject, bl);
    }

    @NotNull
    public final Completable deleteRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new DeleteRoomUseCase().execute(roomId);
    }

    @NotNull
    public final Completable stopRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new StopRoomUseCase().execute(roomId);
    }

    @NotNull
    public final Single<AmityRoomBroadcastData> getBroadcasterData(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new GetBroadcasterDataUseCase().execute(roomId);
    }

    @NotNull
    public final Single<List<String>> getRecordedUrls(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new GetRecordedUrlsUseCase().execute(roomId);
    }

    @NotNull
    public final Completable leaveRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new LeaveRoomUseCase().execute(roomId);
    }

    @NotNull
    public final Completable removeRoomParticipant(@NotNull String roomId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new RemoveRoomParticipantUseCase().execute(roomId, userId);
    }

    @NotNull
    public final Flowable<AmityCoHostEvent> getCoHostEvent(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Flowable flowable = CoHostEventBus.INSTANCE.observe().filter(new Predicate(roomId){
            final /* synthetic */ String $roomId;
            {
                this.$roomId = $roomId;
            }

            public final boolean test(AmityCoHostEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return Intrinsics.areEqual((Object)event.getRoomId(), (Object)this.$roomId);
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"subscribeOn(...)");
        return flowable;
    }
}

