package com.ekoapp.ekosdk.internal.usecase.event

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventSortOption
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus
import com.amity.socialcloud.sdk.model.social.event.AmityEventType
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import com.amity.socialcloud.sdk.social.domain.event.EventComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetEventPagingDataUseCase {

    fun execute(
        originType: AmityEventOriginType?,
        originId: String?,
        userId: String?,
        status: AmityEventStatus?,
        type: AmityEventType?,
        onlyAttendee: Boolean?,
        sortBy: AmityEventSortOption,
        orderBy: AmityEventOrderOption
    ): Flowable<PagingData<AmityEvent>> {
        return EventRepository().getEventPagingData(
            originType = originType,
            originId = originId,
            userId = userId,
            status = status,
            type = type,
            onlyAttendee = onlyAttendee,
            sortBy = sortBy,
            orderBy = orderBy
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { event ->
                EventComposerUseCase().execute(event)
            }
        }
    }
}
