package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus
import com.amity.socialcloud.sdk.social.data.event.paging.EventResponseQueryKeyCreator
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface EventResponsePagingDao : DynamicQueryStreamPagingDao<EventResponseEntity> {

    @RawQuery(observedEntities = [EventResponseEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EventResponseEntity>

    fun getEventResponsePagingSource(
        eventId: String,
        status: AmityEventResponseStatus?
    ): PagingSource<Int, EventResponseEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "event_response",
                primaryKeyColumnName = "rsvpId",
                nonce = AmityNonce.EVENT_RSVP_QUERY,
                sortColumn = "respondedAt",
                order = AmityPagingDao.Order.DESC,
                dynamicQueryStreamKeyCreator = EventResponseQueryKeyCreator(
                    eventId = eventId,
                    status = status
                )
            )
        )
    }
}
