package com.amity.socialcloud.sdk.video.domain.watch

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionRepository
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import org.amity.types.ObjectId
import org.joda.time.DateTime

internal class CreateWatchSessionUseCase {

    fun execute(room: AmityRoom, startedAt: DateTime): Single<String> {
        return Single.fromCallable {
            val prefix = when (room.getStatus()) {
                AmityRoomStatus.LIVE -> "live_"
                AmityRoomStatus.RECORDED -> "playback_"
                else -> throw AmityException.create(
                    "room is not in watchable state",
                    null,
                    AmityError.BUSINESS_ERROR
                )
            }
            val sessionId = prefix + ObjectId().toHexString()
            insertSession(sessionId, room.getRoomId(), startedAt)
            sessionId
        }.subscribeOn(Schedulers.io())
    }

    private fun insertSession(sessionId: String, roomId: String, startedAt: DateTime) {
        WatchSessionRepository().createWatchSession(sessionId, roomId, startedAt)
    }
}
